<?php
ini_set('display_errors', 0);
ini_set('display_startup_errors', 1);
//ini_set('precision',90);
error_reporting(E_ALL);
header('Content-Type: text/html; charset=utf-8');

include 'keccak.php';
use kornrunner\Keccak; 

// Last Updated: 2022-08-05 11:25 By TAimur
//////////////////////////////////////////////
/***************
The purpose of this script is to categorize an input string into
all possible defined categories.
The categories with sample input strings are define with each category code block below.
Attention should be given to sample strings.
Remober: AN input can also possible contain Unicode characters, so keep this in mind.

The script has to be well commented for other developers to understand and use.
The script shoulw be error free and comprhensively tested.
***************/
/////////////////////////////////////////////
//
//
//
//
//
//////////////-----Functions Block----//////////////////////////////// START
/***************
Define all the functions used in the script here
***************/
function utf8_strrev($str){
    preg_match_all('/./us', $str, $ar);
    return join('', array_reverse($ar[0]));
}

function unicode2decimal($c) {
    if (ord($c[0]) >=0 && ord($c[0]) <= 127)
        return ord($c[0]);
    if (ord($c[0]) >= 192 && ord($c[0]) <= 223)
        return (ord($c[0])-192)*64 + (ord($c[1])-128);
    if (ord($c[0]) >= 224 && ord($c[0]) <= 239)
        return (ord($c[0])-224)*4096 + (ord($c[1])-128)*64 + (ord($c[2])-128);
    if (ord($c[0]) >= 240 && ord($c[0]) <= 247)
        return (ord($c[0])-240)*262144 + (ord($c[1])-128)*4096 + (ord($c[2])-128)*64 + (ord($c[3])-128);
    if (ord($c[0]) >= 248 && ord($c[0]) <= 251)
        return (ord($c[0])-248)*16777216 + (ord($c[1])-128)*262144 + (ord($c[2])-128)*4096 + (ord($c[3])-128)*64 + (ord($c[4])-128);
    if (ord($c[0]) >= 252 && ord($c[0]) <= 253)
        return (ord($c[0])-252)*1073741824 + (ord($c[1])-128)*16777216 + (ord($c[2])-128)*262144 + (ord($c[3])-128)*4096 + (ord($c[4])-128)*64 + (ord($c[5])-128);
    if (ord($c[0]) >= 254 && ord($c[0]) <= 255)    //  error
        return FALSE;
    return 0;
}   //  function _uniord()

//echo _uniord("ÃƒÂ°Ã…Â¸Ã‹Å“Ã¢â€šÂ¬");


function decimal2unicode($o) {
    if (function_exists('mb_convert_encoding')) {
        return mb_convert_encoding('&#'.intval($o).';', 'UTF-8', 'HTML-ENTITIES');
    } else {
        return chr(intval($o));
    }
}   // function _unichr()

function emoji_length($string) {
    $strlen = mb_strlen($string);
    while ($strlen) {
        $array[] = mb_substr($string,0,1,"UTF-8");
        $string = mb_substr($string,1,$strlen,"UTF-8");
        $strlen = mb_strlen($string);
    }
    return count($array);
}

function emoji_to_unicode($emoji) {
	
	$emojiArray = preg_split('//u', $emoji, -1, PREG_SPLIT_NO_EMPTY);
	$unicode="";
	foreach($emojiArray as $emojis)
	{
		$emojis = mb_convert_encoding($emojis, 'UTF-32', 'UTF-8');
		//$unicode .= strtoupper(preg_replace("/^[0]+/","U+",bin2hex($emojis))) ." ";
		$unicode .= strtoupper(preg_replace("/^[0]{1,4}/","",bin2hex($emojis))) ." ";
	}
   
   return trim($unicode);
}

function generateTokenId($ens){
    $hash = Keccak::hash($ens, 256);
    $hash = '0x'.$hash;
    $tokenid = gmp_strval(gmp_init($hash));
    return $tokenid;
}

//////////////-----Functions Block----//////////////////////////////// END

//$input=mb_strtolower("abcðŸ”¥");
$input=mb_strtolower($_GET['domain']);
$input=preg_replace('/.eth$/u', '', $input);
$length=mb_strlen($input);
$characters=grapheme_strlen($input);
$size=emoji_length($input);
$category=array();
//$ord = unpack('N', mb_convert_encoding('ðŸ”¥', 'UCS-4BE', 'UTF-8'));
//echo "xxxxxx>".$ord[1];
if (strlen($input) != strlen(utf8_decode($input)))
    $isUTF8=1;
else 
	$isUTF8=0;
if($isUTF8)
	$inputArray = preg_split('//u', $input, -1, PREG_SPLIT_NO_EMPTY);
else
	$inputArray = preg_split('//', $input, -1, PREG_SPLIT_NO_EMPTY);




//////////////////////**************////////////////////////////

//--------------------DB Connection---------------------------//
//--------------------    START    ---------------------------//
//////////////////////**************////////////////////////////
$servername = "areteapps.com";
$username = "areteapps_dat_usr";
$password = "(kH!C4MrF)gg";
$dbname = "areteapps_dat";

// Create connection
$conn = new mysqli($servername, $username, $password);

// Check connection
if (!$conn || $conn->connect_error) {
  	die("Connection failed: " . $conn->connect_error);
	$db_conn=0;
}
else{
	$conn -> set_charset('utf8mb4');
	$conn-> select_db( $dbname);
	$db_conn=1;
}

//////////////////////**************////////////////////////////
//--------------------DB Connection---------------------------//
//--------------------     END     ---------------------------//
//////////////////////**************////////////////////////////

/*START *************  Category: 999 Club *****************/
///Detail/// Name with 3 digits: 000-999.
//Sample///  062
//Sample///  466
{
	if(is_numeric($input) and $input<1000)
	{
		$category[]=array(1,'999 Club');
	}
}
/*End -- 999 Club -- */
//
//
//
//
//
/*START *************  Category: 10k Club *****************/
///Detail/// Names with 4 Digits: 0000-9999
//Sample///  9689
//Sample///  0298
//Sample///  9999
{
	if(is_numeric($input) && $input>999 && $input<10000)
	{ 
		$category[]=array(2,'10k Club');
	}
}
/*End -- 10k Club -- */
//
//
//
//
//
/*START *************  Category: 100k Club *****************/
///Detail/// Names with 5 Digits: 00000-99999.
//Sample///  35207
//Sample///  02593
//Sample/// 
{
	if(is_numeric($input) && $input>9999 && $input < 100000)
	{
		$category[]=array(3,'100k Club');
	}
}
/*End -- 100k Club -- */
//
//
//
//
//
/*START *************  Category: 3 Digit Palindromes *****************/
///Detail/// Palindromes with 3 digits
//Sample///  929
//Sample///  010
//Sample///  000
{
	if (is_numeric($input) && $length == 3 && strrev($input) == $input )
	{
		$category[]=array(4,'3 Digit Palindromes');
	}
}
/*End -- 3 Digit Palindromes -- */
//
//
//
//
//
/*START *************  Category: 4 Digit Palindromes *****************/
///Detail/// Palindromes with 4 digits
//Sample///  4114
//Sample///  4444
//Sample/// 1661
{
	if (is_numeric($input) && $length == 4 && strrev($input) == $input )
	{
		$category[]=array(5,'4 Digit Palindromes');
	}
}
/*End -- 4 Digit Palindromes -- */
//
//
//
//
//
/*START *************  Category: 5 Digit Palindromes *****************/
///Detail/// Palindromes with 5 digits.
//Sample///  03730
//Sample///  19491
//Sample/// 
{
	if (is_numeric($input) && $length == 5 && strrev($input) == $input )
	{
		$category[]=array(6,'5 Digit Palindromes');
	}
}

/*End -- 5 Digit Palindromes -- */
//
//
//
//
//
/*START *************  Category: Binary Club *****************/
///Detail/// Names in 8-bit Binary.
//Sample///  11101100
//Sample///  11110000
//Sample/// 00000001
{
	if (is_numeric($input) && $length == 8 && preg_match('/^[0-1]*$/', $input) )
	{
		$category[]=array(7,'Binary Club');
	}
}
/*End -- Binary Club -- */

//
//
//
//
//
/*START *************  Category: 1 Hex Club *****************/
///Detail/// 0x1Hex Names.
//Sample///  0x4
//Sample///  0x7
//Sample/// 0xp
{
	if($length==3)
	{
		if(preg_match("/^0x[a-z0-9]{1}$/",$input))
			$category[]=array(8,'1 Hex Club');
	}
}
/*End -- 1 Hex Club -- */
//
//
//
//
//
/*START *************  Category: 0x99 Club *****************/
///Detail/// Names with 0x2Digits.
//Sample///  0x13
//Sample///  0x00
//Sample/// 0x04
{
	if($length==4)
	{
		if(preg_match("/^0x[0-9]{2}$/",$input))
			$category[]=array(9,'0x99 Club');
	}
}
/*End -- 0x99 Club -- */
//
//
//
//
//
/*START *************  Category: 0x999 Club *****************/
///Detail/// Names with 0x3Digits.
//Sample///  0x289
//Sample/// 0x068 
//Sample/// 
{
	if($length==5)
	{
		if(preg_match("/^0x[0-9]{3}$/",$input))
			$category[]=array(10,'0x999 Club');
	}
}
/*End -- 0x999 Club -- */
//
//
//
//
//

/*START *************  Category: 0x10k Club *****************/
///Detail/// Names with 0x4Digits.
//Sample///  0x5434
//Sample///  0x0540
//Sample/// 
{
	if($length==6)
	{
		if(preg_match("/^0x[0-9]{4}$/",$input))
			$category[]=array(11,'0x10k Club');
	}
}
/*End -- 0x10k Club -- */
//
//
//
//
//
/*START *************  Category: 2 Hex Club *****************/
///Detail/// 0x2Hex Names.
//Sample///  0xce
//Sample///  0x9b
//Sample/// 0x34
//Sample/// 0x02
{
	if($length==4)
	{
		if(preg_match("/^0x[0-9a-z]{2}$/",$input))
			$category[]=array(12,'2 Hex Club');
	}
}
/*End -- 2 Hex Club -- */
//
//
//
//
//
/*START *************  Category: 3 Hex Club *****************/
///Detail/// 0x3Hex Names.
//Sample///  0x52e
//Sample///  0x279
//Sample/// 0x020
//Sample/// 0xbfc
{
	if($length==5)
	{
		if(preg_match("/^0x[0-9a-z]{3}$/",$input))
			$category[]=array(13,'3 Hex Club');
	}
}
/*End -- 3 Hex Club -- */
//
//
//
//
//
/*START *************  Category: Traditional CN 999 Club *****************/
///Detail/// é›¶é›¶é›¶-çŽ–çŽ–çŽ– (Traditional CN)
//Sample///  è‚†æŸ’å£¹.eth
//Sample///  è²³æŸ’åƒ.eth
//Sample/// 
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[é›¶å£¹è²³åƒè‚†ä¼é™¸æŸ’æŒçŽ–]{3}$/u",$input))
			$category[]=array(14,'Traditional CN 999 Club');
	}
}
/*End -- Traditional CN 999 Club -- */
//
//
//
//
//
/*START *************  Category: 999 CN Club *****************/
///Detail/// é›¶é›¶é›¶ - ä¹ä¹ä¹ (western simplified)
//Sample///  ä¹ä¸ƒä¹.eth
//Sample///  é›¶é›¶é›¶.eth
//Sample///  å…­äºŒå…­.eth
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[é›¶ä¸€äºŒä¸‰å››äº”å…­ä¸ƒå…«ä¹]{3}$/u",$input))
			$category[]=array(15,'999 CN Club');
	}
}
/*End -- 999 CN Club -- */
//
//
//
//
//
/*START *************  Category: 999 Club ENS Chinese *****************/
///Detail/// é›¶é›¶ä¸€ - ä¹ç™¾ä¹åä¹ (001-999) Chinese Club (Simplified)
//Sample///  äºŒç™¾ä¸€åä¸‰.eth
//Sample///  ä¸‰ç™¾å››åå…­.eth
//Sample/// ä¸€ç™¾ä¸€åäº”.eth
{
	if($length>=3 && $length<=5 && (mb_strpos($input,'å') || mb_strpos($input,'ç™¾')) && $isUTF8)
	{
		if(preg_match("/^[é›¶ä¸€äºŒä¸‰å››äº”å…­ä¸ƒå…«ä¹åç™¾]{3,5}$/u",$input))
			$category[]=array(16,'999 Club ENS Chinese');
	}
}
/*End -- 999 Club ENS Chinese -- */
//
//
//
//
//
/*START *************  Category: 10k CN Club *****************/
///Detail/// é›¶é›¶é›¶é›¶ - ä¹ä¹ä¹ä¹ (simplified)
//Sample///  é›¶äºŒå…­é›¶.eth
//Sample///  ä¹äºŒä¸ƒäºŒ.eth
//Sample/// å…«å…­ä¸ƒé›¶.eth
{
	if($length==4 && $isUTF8)
	{
		if(preg_match("/^[é›¶ä¸€äºŒä¸‰å››äº”å…­ä¸ƒå…«ä¹]{4}$/u",$input))
			$category[]=array(17,'10k CN Club');
	}
}
/*End -- 10k CN Club -- */
//
//
//
//
//
/*START *************  Category: Arabic 999 Club *****************/
///Detail/// Arabic numerals 000-999.
//Sample///  Ù§Ù¤Ù¨.eth
//Sample///  Ù Ù¥Ù¨.eth
//Sample/// 
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[Ù Ù¡Ù¢Ù£Ù¤Ù¥Ù¦Ù§Ù¨Ù©]{3}$/u",$input))
			$category[]=array(18,'Arabic 999 Club');
	}
}
/*End -- Arabic 999 Club -- */
//
//
//
//
//
/*START *************  Category: Arabic 10k Club *****************/
///Detail/// Arabic numerals 0000-9999.
//Sample///  Ù¢Ù£Ù¦Ù¨.eth
//Sample///  Ù Ù¢Ù¨Ù©.eth
//Sample/// 
{
	if($length==4 && $isUTF8)
	{
		if(preg_match("/^[Ù Ù¡Ù¢Ù£Ù¤Ù¥Ù¦Ù§Ù¨Ù©]{4}$/u",$input))
			$category[]=array(19,'Arabic 10k Club');
	}
}
/*End -- Arabic 10k Club -- */
//
//
//
//
//
/*START *************  Category: Hindi 999 Club *****************/
///Detail/// 000-999 in Hindi(Devanagari Script)
//Sample///  à¥«à¥¦à¥¯.eth
//Sample///  à¥¨à¥§à¥«.eth
//Sample/// à¥¦à¥¦à¥­.eth
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[à¥¦à¥§à¥¨à¥©à¥ªà¥«à¥¬à¥­à¥®à¥¯]{3}$/u",$input))
			$category[]=array(20,'Hindi 999 Club');
	}
}
/*End -- Hindi 999 Club -- */
//
//
//
//
//
/*START *************  Category: Hindi 10K Club *****************/
///Detail/// 0000-9999 in Hindi(Devanagari Script)
//Sample///  à¥¬à¥¯à¥«à¥¯.eth
//Sample///  à¥¬à¥¬à¥§à¥«.eth
//Sample/// 
{
	if($length==4 && $isUTF8)
	{
		if(preg_match("/^[à¥¦à¥§à¥¨à¥©à¥ªà¥«à¥¬à¥­à¥®à¥¯]{4}$/u",$input))
			$category[]=array(21,'Hindi 10K Club');
	}
}
/*End -- Hindi 10K Club -- */
//
//
//
//
//
/*START *************  Category: Bengali 999 Club *****************/
///Detail/// Bengali numerals 000-999.
//Sample///  à§§à§ªà§¯.eth
//Sample///  à§¨à§¯à§«.eth
//Sample/// à§§à§­à§ª.eth
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[à§¦à§§à§¨à§©à§ªà§«à§¬à§­à§®à§¯]{3}$/u",$input))
			$category[]=array(22,'Bengali 999 Club');
	}
}
/*End -- Bengali 999 Club -- */
//
//
//
//
//
/*START *************  Category: Persian 999 Club *****************/
///Detail/// Persian numerals 000-999
//Sample///  Û¶Û±Û°.eth
//Sample///  Û°Û¸Û·.eth
//Sample/// ÛµÛ°Û¹.eth
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[Û°Û±Û²Û³Û´ÛµÛ¶Û·Û¸Û¹]{3}$/u",$input))
			$category[]=array(23,'Persian 999 Club');
	}
}
/*End -- Persian 999 Club -- */
//
//
//
//
//
/*START *************  Category: Korean 999 Club *****************/
///Detail/// ì˜ì˜ì˜ - êµ¬êµ¬êµ¬ (Sino-Korean)
//Sample///  ìœ¡ì˜ì‚¬.eth
//Sample///  ì¹ ì¹ ì¹ .eth
//Sample/// íŒ”ì¹ íŒ”.eth
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[ì˜ì¼ì´ì‚¼ì‚¬ì˜¤ìœ¡ì¹ íŒ”êµ¬]{3}$/u",$input))
			$category[]=array(24,'Korean 999 Club');
	}
}
/*End -- Korean 999 Club -- */

//
//
//
//
//
/*START *************  Category: Thai 999 Club *****************/
///Detail/// Thai numerals à¹à¹à¹-à¹™à¹™à¹™.
//Sample///  à¹à¹™à¹˜.eth
//Sample///  à¹˜à¹•à¹˜.eth
//Sample/// à¹—à¹’à¹•.eth
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[à¹à¹‘à¹’à¹“à¹”à¹•à¹–à¹—à¹˜à¹™]{3}$/u",$input))
			$category[]=array(25,'Thai 999 Club');
	}
}
/*End -- Thai 999 Club -- */
//
//
//
//
//
/*START *************  Category: 999-Japan-Simplified *****************/
///Detail/// Simplified Japanese numerals 000-999
//Sample///  å…­ã€‡ä¸‰.eth
//Sample///  äºŒã€‡äºŒ.eth
//Sample/// äºŒã€‡å…«.eth
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[ã€‡ä¸€äºŒä¸‰å››äº”å…­ä¸ƒå…«ä¹]{3}$/u",$input))
			$category[]=array(26,'999-Japan-Simplified');
	}
}
/*End -- 999-Japan-Simplified -- */
//
//
//
//
//
/*START *************  Category: 999 Japan Official *****************/
///Detail/// Japanese Daiji Numbers é›¶é›¶é›¶-çŽ–çŽ–çŽ–
//Sample///  å‚è‚†é›¶.eth
//Sample///  æ¼†æ¼†é™¸.eth
//Sample/// æ¼†æ¼†çŽ–.eth
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[é›¶å£±å¼å‚è‚†ä¼é™¸æ¼†æŸ’æŒçŽ–]{3}$/u",$input))
						  
			$category[]=array(27,'999 Japan Official');
	}
}
/*End -- 999 Japan Official -- */
//
//
//
//
//
/*START *************  Category: 3 Digits Hebrew Club *****************/
///Detail/// 729 Juxtaposed Numbers Written in Hebrew.
//Sample///  ×•×‘×“.eth
//Sample///  ×–×”×.eth
//Sample/// ×–×•×•.eth
{
	if($length==3 && $isUTF8)
	{
		if(preg_match("/^[××‘×’×“×”×•×–×—×˜×™]{3}$/u",$input))
						  
			$category[]=array(28,'3 Digits Hebrew Club');
	}
}
/*End -- 3 Digits Hebrew Club -- */
//
//
//
//
//
/*START *************  Category: Hyphens-NN *****************/
///Detail/// Hyphenated ENS domains.
//Sample///  4-7
//Sample///  0-0
//Sample/// 
{
	if($length==3)
	{
		if(preg_match("/^\d{1}-\d{1}$/",$input))
			$category[]=array(29,'Hyphens-NN');
	}
	
}
/*End -- Hyphens-NN -- */
//
//
//
//
//
/*START *************  Category: Hyphens-LN-NL *****************/
///Detail/// Hyphenated ENS domains.
//Sample///  n-2
//Sample///  4-k
//Sample/// 
{
	if($length==3)
	{
		if(preg_match("/^[a-z0-9]{1}-[a-z0-9]{1}$/",$input))
			$category[]=array(30,'Hyphens-LN-NL');
	}
}
/*End -- Hyphens-LN-NL -- */
//
//
//
//
//
/*START *************  Category: 360 Degrees Club *****************/
///Detail/// 360 Degrees Club
//Sample///  225Â°
//Sample///  008Â°
//Sample/// 100Â°
{
	if($length==4)
	{
		if(preg_match("/^[0-9]{3}Â°$/",$input))
			$category[]=array(31,'360 Degrees Club');
	}
}
/*End -- 360 Degrees Club -- */
//
//
//
//
//
/*START *************  Category: ENS Date Club *****************/
///Detail/// 1Jan - 31dec
//Sample///  13feb
//Sample///  30may
//Sample/// 
{
	if(($length==4 || $length==5) && ctype_alnum($input))
	{
		if(preg_match("/^[0-9]{1,2}(jan|feb|mar|apr|may|jun|jul|aug|sup|oct|nov|dec)$/",$input))
			$category[]=array(32,'ENS Date Club');
	}
}
/*End -- ENS Date Club -- */
//
//
//
//
//
/*START *************  Category: 365 Club *****************/
///Detail/// Official 365 Club of ENS names January1st - December31st
//Sample///  december7th
//Sample///  march14th
//Sample/// may7th
{
	if(($length>=5 && $length<=13) && ctype_alnum($input))
	{
		if(preg_match("/^(january|february|march|april|may|june|july|august|september|october|november|december)[0-3]?(([1](st|th))|2nd|3rd|[0456789]th)$/",$input))
			$category[]=array(33,'365 Club');
	}
}
/*End -- 365 Club -- */
//
//
//
//
//
/*START *************  Category: Ordinal Club *****************/
///Detail/// Official Ordinal Club of ENS names 1st - 999th
//Sample///  872nd
//Sample///  817th
//Sample/// 81st
{
	if(($length>=3 && $length<=5) && ctype_alnum($input))
	{
		if(preg_match("/^[0-9]{0,2}(([1](st|th))|2nd|3rd|[0456789]th)$/",$input))
			$category[]=array(34,'Ordinal Club');
	}
}
/*End -- Ordinal Club -- */
//
//
//
//
//
/*START *************  Category: 24h Club: Timekeepers *****************/
///Detail/// The eternal #TimeKeepers.
//Sample///  23h14
//Sample///  07h49
//Sample/// 18h08
{
	if($length==5 && ctype_alnum($input))
	{

		if(preg_match("/^[0-9]{2}h[0-9]{2}$/",$input))
		{
			$timekeepers=explode("h",$input);
			if($timekeepers[0]<=23 && $timekeepers[1]<=59)
				$category[]=array(36,'24h Club: Timekeepers');
		}
	}
}
/*End -- 24h Club: Timekeepers -- */
//
//
//
//
//
/*START *************  Category: 100k+ Club *****************/
///Detail/// Numbers larger than 99999
//Sample///  2939493
//Sample///  000000011
//Sample/// 112354564
{
	if($length>=6 && $length<10 && is_numeric($input) && $input <= 9999999)
	{
		$category[]=array(37,'100k+ Club');
	}
}
/*End -- 100k+ Club -- */
//
//
//
//
//
/*START *************  Category: 3 Letters *****************/
///Detail/// 3 Letter first Names.
//Sample///  jef
//Sample///  law
//Sample/// man
{
	if($length==3 && ctype_alpha($input))
	{
		$category[]=array(38,'3 Letters');
	}
	
}
/*End -- 3 Letters -- */
//
//
//
//
//
/*START *************  Category: 4 Letter Dictionary *****************/
///Detail/// English 4 Letter Dictionary Words.
//Sample///  wost.eth
//Sample///  pily.eth
//Sample/// 
{
	if($length==4 && $db_conn && (ctype_alpha($input) || strpos($input,"-") || strpos($input,"/") || strpos($input,"\/")) && !$isUTF8)
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT word FROM english_dictionary where word='".$toSearch."' and type='dictionary'";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(39,'4 Letter Dictionary');
			}
		}
	}
}

/*End -- 4 Letter Dictionary -- */
//
//
//
//
//
/*START *************  Category: 5 Letter Dictionary *****************/
///Detail/// English 5 Letter Dictionary Words.
//Sample///  scuds.eth
//Sample///  prime.eth
//Sample/// debit.eth
{
	if($length==5 && $db_conn && (ctype_alpha($input) || strpos($input,"-") || strpos($input,"/") || strpos($input,"\/")) && !$isUTF8)
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT word FROM english_dictionary where word='".$toSearch."' and type='dictionary'";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(40,'5 Letter Dictionary');
			}
		}
	}
}
/*End -- 5 Letter Dictionary -- */
//
//
//
//
//
/*START *************  Category: Female Firstnames *****************/
///Detail/// Female Firstnames.
//Sample///  loan.eth
//Sample///  summer.eth
//Sample/// frida.eth
{
	if($db_conn && !preg_match('/[0-9]+/',$input))
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT name FROM name_character where name='".$toSearch."' and classification ='female-name'";
		//echo $sql;
		$result = $conn->query($sql);

		if ($result->num_rows > 0) {
			$category[]=array(41,'Female Firstnames');
		}
	}
}
/*End -- Female Firstnames -- */
//
//
//
//
//
/*START *************  Category: English Adjectives *****************/
///Detail/// English adjectives.
//Sample///  impossible.eth
//Sample///  new.eth
//Sample/// costly.eth
{
	if($db_conn && (ctype_alpha($input) || strpos($input,"-") || strpos($input,"/") || strpos($input,"\/")) && !$isUTF8)
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT word FROM english_dictionary where word='".$toSearch."' and type='adjective'";
		//echo $sql;
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(42,'English Adjectives');
			}
		}
	}
}
/*End -- English Adjectives -- */
//
//
//
//
//
/*START *************  Category: Harry Potter *****************/
///Detail/// Harry Potter characters
//Sample///  auntmuriel.eth
//Sample///  professordumbledore.eth
//Sample/// 
{
	if($db_conn && !preg_match('/[0-9]+/',$input))
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT name FROM name_character where name='".$toSearch."' and classification='harrypotter'";
		//echo $sql;
		$result = $conn->query($sql);

		if ($result->num_rows > 0) {
			$category[]=array(43,'Harry Potter');
		}
	}
}
/*End -- Harry Potter -- */
//
//
//
//
//
/*START *************  Category: English Nouns *****************/
///Detail/// English nouns.
//Sample///  cash.eth
//Sample///  swimming.eth
//Sample/// recipe.eth
{
	if($db_conn && (ctype_alpha($input) || strpos($input,"-") || strpos($input,"/") || strpos($input,"\/")) && !$isUTF8)
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT word FROM english_dictionary where word='".$toSearch."' and type='noun'";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(44,'English Nouns');
			}
		}
	}
}
/*End -- English Nouns -- */
//
//
//
//
//
/*START *************  Category: English Verbs *****************/
///Detail/// English verbs.
//Sample///  reward.eth
//Sample///  home.eth
//Sample/// toy.eth
{
	if($db_conn && (ctype_alpha($input) || strpos($input,"-") || strpos($input,"/") || strpos($input,"\/")) && !$isUTF8)
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT word FROM english_dictionary where word='".$toSearch."' and type='verb'";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if($result->num_rows > 0) {
				$category[]=array(45,'English Verbs');
			}
		}
	}
}
/*End -- English Verbs -- */
//
//
//
//
//
/*START *************  Category: 3 Letter Dictionary *****************/
///Detail/// English 3 letter dictionary words.
//Sample///  man.eth
//Sample///  els.eth
//Sample/// son.eth
{
	if($length==3 && $db_conn && (ctype_alpha($input) || strpos($input,"-") || strpos($input,"/") || strpos($input,"\/")) && !$isUTF8)
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT word FROM english_dictionary where word='".$toSearch."' and type='dictionary'";
		//echo $sql;
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if($result->num_rows > 0) {
				$category[]=array(47,'3 Letter Dictionary');
			}
		}
	}
}
/*End -- 3 Letter Dictionary -- */
//
//
//
//
//
/*START *************  Category: Male Firstnames *****************/
///Detail/// Male Firstnames.
//Sample///  harry.eth
//Sample///  diego.eth
//Sample/// jude.eth
{
	if($db_conn && !preg_match('/[0-9]+/',$input))
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT name FROM name_character where name='".$toSearch."' and classification ='male-name'";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(48,'Male Firstnames');
			}
		}
	}
}
/*End -- Male Firstnames -- */
//
//
//
//
//
/*START *************  Category: 3 Letter First Names *****************/
///Detail/// 3 Letter first Names.
//Sample///  jef.eth
//Sample///  law.eth
//Sample///  man.eth
{
	if($length==3 && $db_conn && ctype_alpha($input))
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT name FROM name_character where name='".$toSearch."' and classification IN('male-name','female-name')";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(49,'3 Letter First Names');
			}
		}
	}
	//$category[]=array(,'3 Letter First Names');
}
/*End -- 3 Letter First Names -- */
//
//
//
//
//
/*START *************  Category: Pokemon Trainer DAO *****************/
///Detail/// Pokemon ENS.
//Sample///  tranquill.eth
//Sample///  volcanion.eth
//Sample/// shellder.eth
{
	if($db_conn && !preg_match('/[0-9]+/',$input))
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT name FROM name_character where name='".$toSearch."' and classification='pokemon'";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(51,'Pokemon Trainer DAO');
			}
		}
	}
}
/*End -- Pokemon Trainer DAO -- */
//
//
//
//
//
/*START *************  Category: Countries *****************/
///Detail/// Country names.
//Sample///  vatican.eth
//Sample///  greece.eth
//Sample/// turkey.eth
{
	if($db_conn && !preg_match('/[0-9]+/',$input))
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT name FROM country where name='".$toSearch."'";
		//echo $sql;
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(52,'Countries');
			}
		}
	}
}
/*End -- Countries -- */
//
//
//
//
//
/*START *************  Category: Country Codes *****************/
///Detail/// 3 Letter Country Codes.
//Sample///  aus.eth
//Sample///  jor.eth
//Sample/// gbr.eth
{
	if($length==3 && $db_conn && !preg_match('/[0-9]+/',$input))
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT name FROM country where 3_letter_code='".$toSearch."'";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(53,'Country Codes');
			}
		}
	}
}
/*End -- Country Codes -- */
//
//
//
//
//
/*START *************  Category: Capital Cities *****************/
///Detail/// Country Capital City Names.
//Sample///  riyadh.eth
//Sample///  tokyo.eth
//Sample/// islamabad.eth
{
	if($db_conn && !preg_match('/[0-9]+/',$input))
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT name FROM city where name='".$toSearch."' and capital_city=1";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(54,'Capital Cities');
			}
			else
			{
				/*START *************  Category: World Cities *****************/
				///Detail/// Popular Cities around the world
				//Sample///  newyork.eth
				//Sample///  manchester.eth
				//Sample/// berlin.eth
				{
					if($db_conn && !preg_match('/[0-9]+/',$input))
					{
						$toSearch = $conn -> real_escape_string(trim($input));
						$sql = "SELECT name FROM city where name='".$toSearch."' and capital_city=0";
						$result = $conn->query($sql);
						if (!$conn->error)
						{
							if ($result->num_rows > 0) {
								$category[]=array(55,'World Cities');
							}
						}
					}
				}
				/*End -- World Cities -- */
			}
		}
	}
}
/*End -- Capital Cities -- */
//
//
//
//
//
/*START *************  Category: Naruto Names *****************/
///Detail/// Names of all characters from Naruto!
//Sample///  hayategekkÅ.eth
//Sample///  gatÅ.eth
//Sample/// chÅhan.eth
{
	if($db_conn && !preg_match('/[0-9]+/',$input))
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT name FROM name_character where name='".$toSearch."' and classification='naruto'";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$category[]=array(58,'Naruto Names');
			}
		}
	}
}
/*End -- Naruto Names -- */
//
//
//
//
//
/*START *************  Category: Triple Ethmoji *****************/
///Detail/// Names with True Triple Emojis
//Sample///  ðŸ•™ðŸ•™ðŸ•™.eth
//Sample///  ðŸ”¼ðŸ”¼ðŸ”¼.eth
//Sample/// â¯â¯â¯.eth
{
	//echo $input;
	//echo "<br>Characters: ".grapheme_strlen($input);
	//echo "<br>Length: ".emoji_length($input)."\n\n";
	
	if($db_conn && $isUTF8 && $length==3)
	{
		$next=0;
		$single_emoji=(grapheme_extract($input,1,GRAPHEME_EXTR_COUNT,$next,$next));
		$single_emoji_code=(emoji_to_unicode($single_emoji));
		$toSearch = $conn -> real_escape_string(trim($single_emoji_code));
		$sql = "SELECT code FROM emoji where code='".$toSearch."'";
		//echo $sql;
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0)
			{
				$same=1;
				for ($i = 1; $i < $length; $i++)
        			if ($inputArray[$i] != $inputArray[0])
            			$same=0;
 
				if($same)
				{
					$category[]=array(60,'Triple Ethmoji');
				}
			}
		}
	}
}
/*End -- Triple Ethmoji -- */
//
//
//
//
//
/*START *************  Category: 0xEmojis *****************/
///Detail/// 0x Emojis Names
//Sample///  0xðŸ’œ.eth
//Sample///  0xðŸŒŸ.eth
//Sample/// 0xi.eth
{
	if($length==3)
	{	
		if(preg_match("/^0x(.){1}$/u",$input))
		{
			$i3=preg_replace('/^0x/u', '', $input);
			//die($i3);
			$next=0;
			$single_emoji=(grapheme_extract($i3,1,GRAPHEME_EXTR_COUNT,$next,$next));
			$single_emoji_code=(emoji_to_unicode($single_emoji));
			$toSearch = $conn -> real_escape_string(trim($single_emoji_code));
			//$sql = "SELECT code FROM emoji where code='".$toSearch."'";
			//echo $sql."<br>&#x".$single_emoji_code.";<br>";
			$result = $conn->query($sql);
			if (!$conn->error)
			{
				if ($result->num_rows > 0)
				{
					$category[]=array(61,'0xEmojis');
				}
			}
		}
			
	}
}
/*End -- 0xEmojis -- */
//
//
//
//
//
/*START *************  Category: Single Ethmoji *****************/
///Detail/// Names with True Single Emojis
//Sample///  ðŸ‘©ðŸ»â€â¤â€ðŸ’‹â€ðŸ‘¨ðŸ¾.eth
//Sample///  ðŸ§ðŸ¾â€â™€.eth
//Sample/// ðŸ¦¸â€â™‚.eth
{	
	//echo "Chars".$characters." - Size: ".$size."<br>";
	if($characters==1 && $size>=3)
	{	
		
		$next=0;
		$single_emoji=(grapheme_extract($input,1,GRAPHEME_EXTR_COUNT,$next,$next));
		$single_emoji_code=(emoji_to_unicode($single_emoji));
		$toSearch = $conn -> real_escape_string(trim($single_emoji_code));
		$sql = "SELECT code FROM emoji where code='".$toSearch."'";
		//echo $sql."<br>&#x".$single_emoji_code.";<br>";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0)
			{
				$category[]=array(62,'Single Ethmoji');
			}
		}
			
	}
}
/*End -- Single Ethmoji -- */
//
//
//
//
//
/*START *************  Category: Double Ethmoji *****************/
///Detail/// Names with True Double Emojis.
//Sample///  ðŸ–ðŸ¿ðŸ–ðŸ¿.eth
//Sample///  ðŸ¤µðŸ¿ðŸ¤µðŸ¿.eth
//Sample/// ðŸ‘°ðŸ¼ðŸ‘°ðŸ¼.eth
{	
	//echo "Chars".$characters." - Size: ".$size."<br>";
	if($characters==2 && $size>=3)
	{	
		
		$next=0;
		$single_emoji=(grapheme_extract($input,1,GRAPHEME_EXTR_COUNT,$next,$next));
		$single_emoji_code=(emoji_to_unicode($single_emoji));
		$toSearch = $conn -> real_escape_string(trim($single_emoji_code));
		$sql = "SELECT code FROM emoji where code='".$toSearch."'";
		//echo $sql."<br>&#x".str_replace(" ",";&#x",$single_emoji_code).";<br>";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0)
			{
				$single_emoji2=(grapheme_extract($input,1,GRAPHEME_EXTR_COUNT,$next,$next));
				$single_emoji2_code=(emoji_to_unicode($single_emoji2));
				
        		if($single_emoji2_code==$single_emoji_code)
					$category[]=array(63,'Double Ethmoji');
			}
		}
			
	}
}
/*End -- Double Ethmoji -- */
//
//
//
//
//
/*START *************  Category: Ethmoji 99 Club *****************/
///Detail/// Names with 2 Emoji Digits.
//Sample///  4âƒ£1âƒ£.eth
//Sample///  1âƒ£1âƒ£.eth
//Sample/// 1âƒ£1âƒ£.eth
{
	//echo "Chars".$characters." - Size: ".$size."<br>";
	if($characters==2 && $size>=3)
	{	
		$next=0;
		$is_keycap_1_9=1;
		$keycaps_unicode=array('0030 20E3','0031 20E3','0032 20E3','0033 20E3','0034 20E3','0035 20E3','0036 20E3','0037 20E3','0038 20E3','0039 20E3');
		for($i=0; $i<grapheme_strlen($input); $i++)
		{
			$single_emoji=(grapheme_extract($input,1,GRAPHEME_EXTR_COUNT,$next,$next));
			$single_emoji_code=(emoji_to_unicode($single_emoji));
			if(array_search($single_emoji_code,$keycaps_unicode)===false)
			{
				$is_keycap_1_9=0;
				break;
			}
		}
		
		
		if($is_keycap_1_9)
			$category[]=array(64,'Ethmoji 99 Club');
	}
}
/*End -- Ethmoji 99 Club -- */
//
//
//
//
//
/*START *************  Category: Ethmoji 999 Club *****************/
///Detail/// Names with 3 Emoji Digits.
//Sample///  6âƒ£7âƒ£9âƒ£.eth
//Sample///  5âƒ£0âƒ£2âƒ£.eth
//Sample/// 6âƒ£7âƒ£1âƒ£.eth
{
	//echo "Chars".$characters." - Size: ".$size."<br>";
	if($characters==3 && $size==6)
	{	
		$next=0;
		$is_keycap_1_9=1;
		$keycaps_unicode=array('0030 20E3','0031 20E3','0032 20E3','0033 20E3','0034 20E3','0035 20E3','0036 20E3','0037 20E3','0038 20E3','0039 20E3');
		for($i=0; $i<grapheme_strlen($input); $i++)
		{
			$single_emoji=(grapheme_extract($input,1,GRAPHEME_EXTR_COUNT,$next,$next));
			$single_emoji_code=(emoji_to_unicode($single_emoji));
			if(array_search($single_emoji_code,$keycaps_unicode)===false)
			{
				$is_keycap_1_9=0;
				break;
			}
		}
		
		
		if($is_keycap_1_9)
			$category[]=array(65,'Ethmoji 999 Club');
	}

}
/*End -- Ethmoji 999 Club -- */
//
//
//
//
//
/*START *************  Category: Ethmoji 10k Club *****************/
///Detail/// Ethmoji 10k Club
//Sample///  9âƒ£6âƒ£6âƒ£6âƒ£.eth
//Sample///  0âƒ£1âƒ£9âƒ£5âƒ£.eth
//Sample/// 1âƒ£2âƒ£0âƒ£3âƒ£.eth
{
	//echo "Chars".$characters." - Size: ".$size."<br>";
	if($characters==4 && $size==8)
	{	
		$next=0;
		$is_keycap_1_9=1;
		$keycaps_unicode=array('0030 20E3','0031 20E3','0032 20E3','0033 20E3','0034 20E3','0035 20E3','0036 20E3','0037 20E3','0038 20E3','0039 20E3');
		for($i=0; $i<grapheme_strlen($input); $i++)
		{
			$single_emoji=(grapheme_extract($input,1,GRAPHEME_EXTR_COUNT,$next,$next));
			$single_emoji_code=(emoji_to_unicode($single_emoji));
			if(array_search($single_emoji_code,$keycaps_unicode)===false)
			{
				$is_keycap_1_9=0;
				break;
			}
		}
		
		
		if($is_keycap_1_9)
			$category[]=array(66,'Ethmoji 10k Club');
	}

}
/*End -- Ethmoji 10k Club -- */
//
//
//
//
//
/*START *************  Category: Brands - Tier 1-5 *****************/
///Detail/// Top 100 
//Sample///  
//Sample///  
//Sample/// 
{
	//if($db_conn && !preg_match('/[0-9]+/',$input))
	if($db_conn)
	{
		$toSearch = $conn -> real_escape_string(trim($input));
		$sql = "SELECT name,tier FROM brands where name='".$toSearch."' order by tier ASC";
		//echo $sql;
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			if ($result->num_rows > 0) {
				$brand=$result -> fetch_array();
				if($brand['tier']==1)
					$category[]=array(69,'Brands - Tier 1');
				elseif($brand['tier']==2)
					$category[]=array(70,'Brands - Tier 2');
				elseif($brand['tier']==3)
					$category[]=array(71,'Brands - Tier 3');
				elseif($brand['tier']==4)
					$category[]=array(72,'Brands - Tier 4');
				elseif($brand['tier']==5)
					$category[]=array(73,'Brands - Tier 5');
			}
		}
	}
}
/*End -- Brands - Tier 1-5 -- */
//
//
//
//
//
/*START *************  Category: 3 Letter Palindromes *****************/
///Detail/// Palindromes with 3 letters.
//Sample///  fjf
//Sample///  sss
//Sample/// gig
{
	if (!is_numeric($input) && $length == 3 && utf8_strrev($input) == $input )
	{

		$category[]=array(50,'3 Letter Palindromes');
	}
}
/*End -- 3 Letter Palindromes -- */
//
//
//
//
//
/*START *************  Category: 3 Letter All Vowels *****************/
///Detail/// Names with only 3 vowels.
//Sample///  ueo
//Sample///  oua
//Sample/// eoe
{
	if($length==3)
	{
		if(preg_match("/^[aeiou]{3}$/",$input))
		{
				$category[]=array(56,'3 Letter All Vowels');
		}
	}
}
/*End -- 3 Letter All Vowels -- */
//
//
//
//
//
/*START *************  Category: Hyphens-LL *****************/
///Detail/// Hyphenated ENS domains.
//Sample///  c-q
//Sample///  t-t
//Sample/// e-z
{	
	if($length==3)
	{
		if(preg_match("/^[a-z]{1}-[a-z]{1}$/",$input))
		{
					$category[]=array(57,'Hyphens-LL');
		}
	}
}
/*End -- Hyphens-LL -- */
//
//
//
//
//
/*START *************  Category: Dictionary Word *****************/
///Detail/// Dictionary Words not Classified otherwise.
//Sample///  cannabis.eth
//Sample///  pumpkinseed.eth
//Sample/// franco-american.eth
{
	if($length>5 && $db_conn && (ctype_alpha($input) || strpos($input,"-") || strpos($input,"/") || strpos($input,"\/")) && !$isUTF8)
	{
		$dictionary_categories=array(39, 40, 42, 44, 45, 47);
		$already_dictionary=0;
		if(sizeof($category))
		{
			foreach ($category as $key => $val)
			{
				if(array_search($val[0], $dictionary_categories))
				{
					$already_dictionary=1;
					break;
				}
				
			}
		}
		if(!$already_dictionary)
		{
			$toSearch = $conn -> real_escape_string(trim($input));
			$sql = "SELECT word FROM english_dictionary where word='".$toSearch."' and type='dictionary'";
			$result = $conn->query($sql);
			if (!$conn->error)
			{
				if ($result->num_rows > 0) {
					$category[]=array(78,'Dictionary Word
');
				}
			}
		}
	}
}
/*End -- Dictionary Word  -- */
//
//
//
//
//
/*START *************  Category: English Characters *****************/
///Detail/// All english words longer than 6 characters 
//Sample///  hfdgred
//Sample///  wioscrkdss
//Sample/// fhesuskekkws
{
	if($length>=3 && $length<17)
	{
		
		$letter_categories=array(39, 40, 42, 44, 45, 47, 41, 43, 48, 49, 51, 52, 53, 54, 55, 58, 69, 70, 71, 72, 73, 78);
		$already_letter_category=0;
		if(sizeof($category))
		{
			foreach ($category as $key => $val)
			{
				if(array_search($val[0], $letter_categories))
				{
					$already_letter_category=1;
					break;
				}
				
			}
		}
		
		if(preg_match("/^[a-z]{3,16}$/",$input) && !$already_letter_category)
		{
			$category[]=array(59,'English Characters');
		}
	}	
}
/*End -- English Characters -- */
//
//
//
//
//
/*START *************  Category: One Character Club *****************/
///Detail/// Names with single characters
//Sample///  44444444
//Sample///  111
//Sample///  55555
//Sample/// gggggg
{	
	//echo "Chars".$characters." - Size: ".$size." - Length: ".$size."<br>";
	if($length>=3)
	{	//var_dump(mb_split("",$input));
		$same=0;
		
		if(!$isUTF8)
		{
			$same=1;
			for ($i = 1; $i < $length; $i++)
			{
				if ($inputArray[$i] != $inputArray[0])
				{
					//echo $inputArray[$i] ."!=". $inputArray[0]."<br>";
					$same=0;
				}
			}
		}

		if($characters!=$size  && !($size%$characters) && $characters>=3)
		{
			$same=1;
			$next=0;
			$single_emoji=(grapheme_extract($input,1,GRAPHEME_EXTR_COUNT,$next,$next));
			$single_emoji_code1=(emoji_to_unicode($single_emoji));

			for($i=1; $i<grapheme_strlen($input); $i++)
			{
				$single_emoji=(grapheme_extract($input,1,GRAPHEME_EXTR_COUNT,$next,$next));
				$single_emoji_code=(emoji_to_unicode($single_emoji));
				if($single_emoji_code1 != $single_emoji_code)
				{
					$same=0;
					break;
				}
			}
		}
		
		
		if($same)
		{
			$category[]=array(75,'One Character Club');
			//die($input);
		}
	}
}
/*End -- One Character Club -- */
//
//
//
//
//
/*START *************  Category: Double Pattern *****************/
///Detail/// Names with 2 character patterns
//Sample///  111aaa
//Sample///  3334444
//Sample/// xxxxxyyyyy
{
	if($length>=5)
	{
		preg_match_all( '/(\S{1,}?)\1+/u', $input, $repeatPatterns );
		//var_dump($repeatPatterns);
		$totalRepeatCharacters=0;
		if($repeatPatterns)
		{
			if(count($repeatPatterns[0])==2)
			{
				foreach($repeatPatterns[0] as $repeatPattern)
					$totalRepeatCharacters+=mb_strlen($repeatPattern);
			}
			if($totalRepeatCharacters==$length)
				$category[]=array(76,'Double Pattern');
		}
	}
}
/*End -- Double Pattern -- */
//
//
//
//
//
//$input=mb_strtolower("ðŸ”¥ðŸ”¥ðŸ”¥");
//$input=mb_strtolower("Ù¨Ù¨Ù¨Ù¨aaaðŸ”¥ðŸ”¥ðŸ”¥");
//$length=mb_strlen($input);
//$inputArray = preg_split('//u', $input, -1, PREG_SPLIT_NO_EMPTY);
//echo $input;
//$input=mb_strtolower("1sdsdahaa");
//echo $input;
//$length=mb_strlen($input);
/*START *************  Category: Triple Pattern *****************/
///Detail/// Names with 3 character patterns
//Sample///  222aaa444
//Sample///  55aa66
//Sample/// 7777aaazzz
{
	if($length>=6)
	{
		preg_match_all( '/(\S{1,}?)\1+/u', $input, $repeatPatterns );
		//var_dump($repeatPatterns);
		$totalRepeatCharacters=0;
		if($repeatPatterns)
		{
			if(count($repeatPatterns[0])==3)
			{
				foreach($repeatPatterns[0] as $repeatPattern)
					$totalRepeatCharacters+=mb_strlen($repeatPattern);
			}
			if($totalRepeatCharacters==$length)
				$category[]=array(77,'Triple Pattern');
		}
	}

}
/*End -- Triple Pattern -- */
//
//
//
//
/*START *************  Category: Characters Sequence *****************/
///Detail/// Number or Alphabets in order/Sequence
//Sample///  5678.eth
//Sample///  pqrs.eth
//Sample/// 76543.eth
{
	if(ctype_digit($input))
	{
		$sequence=0;
		//98765
		if($inputArray[0]>$inputArray[1])
		{
			$sequence=1;
			for($i=0; $i<($length-1);$i++)
			{
				if($inputArray[$i+1]!=($inputArray[$i]-1))
					$sequence=0;
			}
		}
		//56789
		if($inputArray[0]<$inputArray[1])
		{
			$sequence=1;
			for($i=0; $i<($length-1);$i++)
			{
				if($inputArray[$i+1]!=($inputArray[$i]+1))
					$sequence=0;
			}
		}
	}
	
//	for($i=0; $i<($length);$i++)
//			{
//				echo $inputArray[$i]." - ".unicode2decimal($inputArray[$i])."<br>";
//			}
	if(ctype_alpha($input))
	{
		$sequence=0;
		//zyxw
		if(unicode2decimal($inputArray[0])>unicode2decimal($inputArray[1]))
		{
			$sequence=1;
			for($i=0; $i<($length-1);$i++)
			{
				if(unicode2decimal($inputArray[$i+1])!=(unicode2decimal($inputArray[$i])-1))
					$sequence=0;
			}
		}
		
		//wxyz
		if(unicode2decimal($inputArray[0])<unicode2decimal($inputArray[1]))
		{
			$sequence=1;
		 	for($i=0; $i<($length-1);$i++)
			{
				if(unicode2decimal($inputArray[$i+1])!=(unicode2decimal($inputArray[$i])+1))
				{
					$sequence=0;
				}
					
			}
		}
	}
	
	if($sequence==1)
		$category[]=array(79,'Characters Sequence');
}
/*End -- Characters Sequence -- */
//
//
//
//
//
/*START *************  Category: Words Combination *****************/
///Detail/// Combination of 2 words
//Sample///  
//Sample///  
//Sample/// 
{
	if($length<15 && $db_conn && (ctype_alpha($input) || strpos($input,"-") || strpos($input,"2") || strpos($input,"4")) && !ctype_digit($input) && !$isUTF8)
	{
		
		$wordsCombo=0;
		if(ctype_alpha($input))
		{
			
			$half=ceil($length/2);
			$word1=substr($input,0,$half);
			$word2=substr($input,$half,$length);			
			$toSearch = $conn -> real_escape_string(trim($input));
			$sql = "SELECT word FROM english_dictionary where word IN ('".$word1."','".$word2."') and type='dictionary'";
			$result = $conn->query($sql);
			if (!$conn->error)
				if ($result->num_rows > 0)
					$wordsCombo=1;
			
			if(!$wordsCombo)
			{
				$word1=substr($input,0,($half-1));
				$word2=substr($input,($half-1),$length);
				$toSearch = $conn -> real_escape_string(trim($input));
				$sql = "SELECT word FROM english_dictionary where word IN ('".$word1."','".$word2."') and type='dictionary'";
				$result = $conn->query($sql);
				if (!$conn->error)
					if ($result->num_rows > 0)
							$wordsCombo=1;	
			}
			
			if(!$wordsCombo)
			{
				$word1=substr($input,0,($half+1));
				$word2=substr($input,($half+1),$length);
				$toSearch = $conn -> real_escape_string(trim($input));
				$sql = "SELECT word FROM english_dictionary where word IN ('".$word1."','".$word2."') and type='dictionary'";
				$result = $conn->query($sql);
				if (!$conn->error)
					if ($result->num_rows > 0)
							$wordsCombo=1;	
			}
		
		}
		
		if(!$wordsCombo && strpos($input,"-"))
		{
			$words=str_replace('-',"','",$input);			
			$toSearch = $conn -> real_escape_string(trim($input));
			$sql = "SELECT word FROM english_dictionary where word IN ('".$words."') and type='dictionary'";
			$result = $conn->query($sql);
			if (!$conn->error)
				if ($result->num_rows > 0)
						$wordsCombo=1;	
		}
		
		if(!$wordsCombo && strpos($input,"2"))
		{
			$words=str_replace('2',"','",$input);
			$toSearch = $conn -> real_escape_string(trim($input));
			$sql = "SELECT word FROM english_dictionary where word IN ('".$words."') and type='dictionary'";
			$result = $conn->query($sql);
			if (!$conn->error)
				if ($result->num_rows > 0)
						$wordsCombo=1;	
		}
		
		if(!$wordsCombo && strpos($input,"4"))
		{
			$words=str_replace('4',"','",$input);
			$toSearch = $conn -> real_escape_string(trim($input));
			$sql = "SELECT word FROM english_dictionary where word IN ('".$words."') and type='dictionary'";
			$result = $conn->query($sql);
			if (!$conn->error)
				if ($result->num_rows > 0)
						$wordsCombo=1;	
		}
				
		
		if($wordsCombo)
		{
			$category[]=array(80,'Words Combination');
		}
			
	}
}
/*End -- Words Combination -- *///


if(sizeof($category))
{
	$category_ids="";
	foreach($category as $sCategory){
		$category_ids.=$sCategory[0].",";
	}
	$category_ids=trim($category_ids,",");
}





if($db_conn && sizeof($category))
	{
		$toSearch = $conn -> real_escape_string(trim($category_ids));
		$sql = "SELECT * FROM domain_category where id IN (".$category_ids.")";
		$result = $conn->query($sql);
		if (!$conn->error)
		{
			$price_point=0;
			$domain_categories=array();
			if ($result->num_rows > 0) {
				while($row = $result->fetch_assoc())
				{
					$domain_categories[]=array($row['price_point'],$row['title'],$row['description']);
					$price_point+=$row['price_point'];
				}
			}
		}
	}

if(!isset($price_point)|| $price_point<5)
	$price_point=5;

$length=$size;

$length_factor=1;
if ($length < 8)		
	$length_factor = 1+((8-$length)/20);	
if ($length > 8 && $length < 17	)	
	$length_factor = 1-(($length-8)/30);	
if ($length > 16 && $length< 30	)	
	$length_factor = 1-(($length-8)/27);	
if ($length > 29 && $length< 50)		
	$length_factor = 0.2;	
if ($length > 49 && $length< 75)		
	$length_factor = 0.16;	
if ($length > 74)		
	$length_factor = 0.1;		



/*
$creation_date=$_GET['cd'];
if($creation_date){
	$date_format=explode("/",$creation_date);
	$creation_date=$date_format[2]."-".$date_format[1]."-".$date_format[0];
}

$registration_date=$_GET['rd'];
if($registration_date){
	$date_format=explode("/",$registration_date);
	$registration_date=$date_format[2]."-".$date_format[1]."-".$date_format[0];
}

$expiration_date=$_GET['ed'];
if($expiration_date){
	$date_format=explode("/",$expiration_date);
	$expiration_date=$date_format[2]."-".$date_format[1]."-".$date_format[0];
}
*/

$tokenID = generateTokenId($input);


$getMetaDataURL = "https://metadata.ens.domains/mainnet/0x57f1887a8BF19b14fC0dF6Fd9B2acc9Af147eA85/".$tokenID."/";

$chMD = curl_init($getMetaDataURL);
curl_setopt($chMD, CURLOPT_RETURNTRANSFER, true);
curl_setopt($chMD, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($chMD, CURLOPT_SSL_VERIFYPEER, false);
$metaDataRaw = curl_exec($chMD);
curl_close($chMD);


if($metaDataRaw)
{
	//$metaDataRaw = fgets($getMetaData);
	$metaData=json_decode($metaDataRaw, true);
	//echo $metaDataRaw."<br><br>";
	//var_dump($metaData["attributes"][0]['value']);
	$creation_date = date("Y-m-d", substr($metaData["attributes"][0]['value'], 0, 10));
	$registration_date = date("Y-m-d", substr($metaData["attributes"][4]['value'], 0, 10));
	$expiration_date = date("Y-m-d", substr($metaData["attributes"][5]['value'], 0, 10));
	
	//echo "Meta Data Response: ".var_dump($metaData);
}



if(strtotime($creation_date) && strtotime($registration_date))
{
	$today=strtotime("now");
	$creation_date_time=strtotime($creation_date);
	//echo "Created ".floor((($today-$creation_date_time)/86440))." Days ago<br>";
	$domain_age_benefit= floor(($today-$creation_date_time)/86440) * 0.00004;
}

if(strtotime($expiration_date))
{
	$today=strtotime("now");
	$expiration_date_time=strtotime($expiration_date);
	//echo "Expiring in ".floor(($expiration_date_time-$today)/86440)." Days<br>";
	$domain_life_benefit= floor(($expiration_date_time-$today)/86440) * 0.00003;
}
//echo $domain_age_benefit."+".$domain_life_benefit;
$domain_history_benefit=1+$domain_age_benefit+$domain_life_benefit;


$domain_value = ((($price_point*$length_factor)*0.05)*$domain_history_benefit);

if($characters != $size)
	$domain_value+=(($domain_value*(1-($characters/$size)))/100)*10;

//$getMetaData= fopen("https://metadata.ens.domains/mainnet/0x57f1887a8BF19b14fC0dF6Fd9B2acc9Af147eA85/26544816994145420484931380962118060518457328474479149692307578111772068885211/", 'r');
if($metaDataRaw)
{
//	$metaDataRaw = fgets($getMetaData);
//	$metaData=json_decode($metaDataRaw, true);
//	echo $metaDataRaw."<br><br>";
//	var_dump($metaData["attributes"][0]['value']);
	
	//echo "<br>Creation Date: ". date("Y-m-d", substr($metaData["attributes"][0]['value'], 0, 10)) ."<br>";
	//echo "Registration Date: ".  date("Y-m-d", substr($metaData["attributes"][4]['value'], 0, 10)) ."<br>";
	//echo "Expiration Date: ".  date("Y-m-d", substr($metaData["attributes"][5]['value'], 0, 10)) ."<br>";
	
}

//echo "<br><br>-----------------------------<br><br>";


$getActivitiesURL = "https://api.reservoir.tools/tokens/0x57f1887a8BF19b14fC0dF6Fd9B2acc9Af147eA85:".$tokenID."/activity/v1?limit=10";

$ch = curl_init($getActivitiesURL);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
$activitiesDataRaw = curl_exec($ch);
curl_close($ch);

//echo $api_response;	
//$getActivitiesData= fopen(, 'r');
//https://api.reservoir.tools/tokens/0x57f1887a8BF19b14fC0dF6Fd9B2acc9Af147eA85:100567917540867090294947113176792694600738763480337589720715443766007246631145/activity/v1?limit=10
if($activitiesDataRaw)
{
	
	$activitiesData=json_decode($activitiesDataRaw, true);
	//echo $activitiesDataRaw."<br><br>";
	//echo "Total Activities:". sizeof($activitiesData['activities']);
	
	foreach($activitiesData['activities'] as $activity)
	{
		//echo "<br>Activity: ".$activity['type']." - Price: ".$activity['price'];
		if($activity['type']=='sale')
		{
			$lastSalePrice=$activity['price'];
			break;
		}
	}
	//echo "<pre>";
	//var_dump($activitiesData);
	//echo "</pre>";
	//$creation_date = date("Y-m-d", substr($metaData["attributes"][0]['value'], 0, 10));
	//$registration_date = date("Y-m-d", substr($metaData["attributes"][4]['value'], 0, 10));
	//$expiration_date = date("Y-m-d", substr($metaData["attributes"][5]['value'], 0, 10));
	
	
}

if($lastSalePrice)
{
	if($domain_value > $lastSalePrice)
		$domain_value-=($lastSalePrice/100)*25;
	else
		$domain_value+=($lastSalePrice/100)*25;
}


/*

echo "<br>Token ID: ". $tokenID;
echo "<br>Input: ".$input."<br>";
echo "Categories: ".$category_ids."<br>";
echo "Price Point(Sum): ".$price_point."<br>";	
echo "Length: ".$length."<br>";
echo "Last Sale Price: ".$lastSalePrice."<br>";

if($metaData)
{
echo "<br>Creation Date: ". date("Y-m-d", substr($metaData["attributes"][0]['value'], 0, 10)) ."<br>";
echo "Registration Date: ".  date("Y-m-d", substr($metaData["attributes"][4]['value'], 0, 10)) ."<br>";
echo "Expiration Date: ".  date("Y-m-d", substr($metaData["attributes"][5]['value'], 0, 10)) ."<br>";

}
echo "Length Factor: ".round($length_factor, 3, PHP_ROUND_HALF_UP)."<br>";
echo "Age/History Benefit: ".$domain_history_benefit."<br>";

echo "Domain Value: ".round($domain_value,3,PHP_ROUND_HALF_UP)."<br>";

echo "<pre>";
	var_dump($domain_categories);
echo "</pre>";


*/



?>
<!DOCTYPE html>

<html lang="en">



<head>
    <!-- ========== Meta Tags ========== -->
    <meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="DAT - Prototype - Domain Appraisal Tool">

    <!-- ========== Page Title ========== -->
    <title>DAT - Prototype - Domain Appraisal Tool</title>

    <!-- ========== Favicon Icon ========== -->
    <link rel="shortcut icon" href="assets/img/favicon.png" type="image/x-icon">

    <!-- ========== Start Stylesheet ========== -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" />
    <link href="assets/css/font-awesome.min.css" rel="stylesheet" />
    <link href="assets/css/themify-icons.css" rel="stylesheet" />
    <link href="assets/css/elegant-icons.css" rel="stylesheet" />
    <link href="assets/css/flaticon-set.css" rel="stylesheet" />
    <link href="assets/css/magnific-popup.css" rel="stylesheet" />
    <link href="assets/css/owl.carousel.min.css" rel="stylesheet" />
    <link href="assets/css/owl.theme.default.min.css" rel="stylesheet" />
    <link href="assets/css/animate.css" rel="stylesheet" />
    <link href="assets/css/validnavs.css" rel="stylesheet" />
    <link href="assets/css/style.css" rel="stylesheet" />
    <link href="style.css" rel="stylesheet">
    <link href="assets/css/responsive.css" rel="stylesheet" />
    <!-- ========== End Stylesheet ========== -->


    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5/html5shiv.min.js"></script>
      <script src="assets/js/html5/respond.min.js"></script>
    <![endif]-->



</head>



<body>


    <!-- Preloader Start -->
    <div class="se-pre-con"></div>
    <!-- Preloader Ends -->


    <!-- Header 
    ============================================= -->
    <header>
        <!-- Start Navigation -->
        <nav class="navbar mobile-sidenav navbar-common navbar-sticky navbar-default validnavs">




            <div class="container d-flex justify-content-between align-items-center">            


                <!-- Start Header Navigation -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                        <i class="fa fa-bars"></i>
                    </button>
                    <a class="navbar-brand" href="index.html">
                        <img src="assets/img/logo.png" class="logo" alt="Logo">
                    </a>
                </div>
                <!-- End Header Navigation -->


                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse" id="navbar-menu">


                    <img src="assets/img/logo.png" alt="Logo">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                        <i class="fa fa-times"></i>
                    </button>
                    
                    <ul class="nav navbar-nav navbar-right text-white" data-in="fadeInDown" data-out="fadeOutUp">
                            <li class="dropdown">
                                <a href="/" class=" active"  >Home</a>
                                
                            </li>
                            <li class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" >Pages</a>
                                <ul class="dropdown-menu">
                                    <li><a href="#">About Us</a></li>
                                    <li><a href="#">Team</a></li>
                                    <li><a href="#">Contact Us</a></li>
                                    <li><a href="#">Error Page</a></li>
                                </ul>
                            </li>
                            
                            <li class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" >Services</a>
                                <ul class="dropdown-menu">
                                    <li><a href="#">Services</a></li>
                                    <li><a href="#">Services Details</a></li>
                                </ul>
                            </li>
                            
                            <li><a href="#">contact</a></li>
                        </ul>
                </div><!-- /.navbar-collapse -->


                <div class="attr-right">
                    <!-- Start Atribute Navigation -->
                    <div class="attr-nav">
                        <ul>
                            <li class="button"><a href="#">Sign In</a></li>
                        </ul>
                    </div>
                    <!-- End Atribute Navigation -->
                </div>


                <!-- Main Nav -->
            </div>   
            <!-- Overlay screen for menu -->
            <div class="overlay-screen"></div>
            <!-- End Overlay screen for menu -->
        </nav>
        <!-- End Navigation -->
    </header>
    <!-- End Header -->


     <!-- Start Breadcrumb 
    ============================================= -->
    <div class="breadcrumb-area shadow dark bg-cover text-center text-light" style="background-image: url(assets/img/appraisal-bg-1.jpg);">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <h1>Domain Appraisal</h1>
                    <ul class="breadcrumb">
                        <li><a href="./"><i class="fas fa-home"></i> Home</a></li>
                        <li>Appraisal</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb -->

	<!-- Star Services Details Area
    ============================================= -->
    <div class="services-details-area default-padding">
        <div class="container">
            <div class="services-details-items">
                <div class="row">
                    
                    <div class="col-lg-8 services-single-content">
                        <h2 id="domain-name"><?php echo $input;?>.eth</h2>


                        <p>
                           <?php 
                           // echo "Input: ".$input."<br>";

//echo "Categories: ".$category_ids."<br>";

//echo "Price Point(Sum): ".$price_point."<br>";	

//echo "Length Factor: ".$length_factor."<br>";



//echo "<pre>";

//	var_dump($domain_categories);

//echo "</pre>";





							?>
                        </p>
                        
                        <div class="services-more">
                            <h4>Domain Appraisal</h4>
                            <div class="row">
                                <div class="col-lg-6 col-md-6" id="domain-value">
                                    <div class="item">
                                        <i class="flaticon-message"></i>
                                        <h4><a href="#">Domain Value</a></h4>
                                        <p>
                                            <?php 

												echo $domain_value; 

											?> <img src="./assets/ethereum-eth-logo.png" style="width: 16px;">
                                        </p>
                                    </div>
                                </div>
                            </div>
							
							<div class="row">
								<div class="col-lg-6 col-md-6">
                                    <div class="item">
                                        <i class="flaticon-label"></i>
                                        <h4><a href="#">Length</a></h4>
                                        <p>
                                            <?php echo $length;?>
                                        </p>
                                    </div>
                                </div>
								<?php if($lastSalePrice){?>
								<div class="col-lg-6 col-md-6" id="domain-value">
                                    <div class="item">
                                        <i class="flaticon-message"></i>
                                        <h4><a href="#">Last Sale</a></h4>
                                        <p>
                                            <?php 

												echo $lastSalePrice; 

											?> <img src="./assets/ethereum-eth-logo.png" style="width: 16px;">
                                        </p>
                                    </div>
                                </div>
								<?php }?>
								
							</div>
							
							<?php if($metaData){?>
							<div class="row">
                                <div class="col-lg-4 col-md-4">
                                    <div class="item">
                                        <i class="flaticon-label"></i>
                                        <h4><a href="#">Creation Date</a></h4>
                                        <p>
                                         	<?php echo date("Y-m-d", substr($metaData["attributes"][0]['value'], 0, 10));?>
                                        </p>
                                    </div>
                                </div>
								 <div class="col-lg-4 col-md-4">
                                    <div class="item">
                                        <i class="flaticon-label"></i>
                                        <h4><a href="#">Registration Date</a></h4>
                                        <p>
                                            <?php echo 	$registration_date = date("Y-m-d", substr($metaData["attributes"][4]['value'], 0, 10)); ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4" id="domain-value">
                                    <div class="item">
                                        <i class="flaticon-message"></i>
                                        <h4><a href="#">Expiry Date</a></h4>
                                        <p>
                                            <?php 

												echo $expiration_date = date("Y-m-d", substr($metaData["attributes"][5]['value'], 0, 10)); 

											?> 
                                        </p>
                                    </div>
                                </div>
                            </div>
                        	<?php }?>
						</div>

					<div class="row">
                       <div class="col-lg-12">
                        <div class="skill-items">
                            <!-- Progress Bar Start -->
                            
                            <?php

								foreach($domain_categories as $domain_category)

								{

							?>

								<div class="progress-box">
                                <h5><?php echo $domain_category[1]?></h5>
                                <div class="progress">
                                    <div class="progress-bar" role="progressbar" data-width="<?php echo $domain_category[0]?>">
                                         <span><?php echo $domain_category[0]?></span>
                                    </div>
                                </div>
                            </div>

										

							<?php

									

									

								}

							

							?>
                            
                            
                            <!-- End Progressbar -->
                        </div>
                    </div>
                       </div>
                       <!--
                        <div class="features">
                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <div class="content">
                                        <h4>Included Services</h4>
                                        <ul>
                                            <li>100% Guarantee Cleaning</li>
                                            <li>24/7 Alltime Supporting</li>
                                            <li>Fully Carefull & Safety Guard</li>
                                            <li>Expert Team Members</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="content">
                                        <h4>Benifits of services</h4>
                                        <ul>
                                            <li>No Hidden Charges</li>
                                            <li>Special Careness Risk Free</li>
                                            <li>Quality Standards</li>
                                            <li>15+ Years Experiences</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <p>
                            Nam libero tempore, cum soluta nobis est elig endi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repelle ndus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias. consequatur aut perferendis doloribus asperiores repellat. The wise man therefore always holds in these matters to this principle of selection: he rejects pleasures to secure other greater pleasures, or else he endures pains to avoid worse pains.  pleasures have to be repudiated and annoyances accepted. 
                        </p>
                        -->
                    </div>


                    <div class="col-lg-4 services-sidebar">
                        <!-- Single Widget -->
                        <div class="single-widget services-list">
                            <h4 class="widget-title">Our Services</h4>
                            <div class="content">
                                <ul>
                                    <li class="current-item"><a href="#">Domain Appraisal</a></li>
                                    <li><a href="#">Expert Advise</a></li>
                                    <li><a href="#">Technologies</a></li>
                                </ul>
                            </div>
                        </div>
                        <!-- End Single Widget -->
                        <div class="single-widget quick-contact text-light" style="background-image: url(assets/img/800x800.png);">
                            <div class="content">
                                <i class="fas fa-phone"></i>
                                <h4>Need any help?</h4>
                                <p>
                                    We are here to help our customer any time. You can call on 24/7 To Answer Your Question.
                                </p>
                                <h2>(012) 6679545</h2>
                            </div>
                        </div>
                        <!-- Single Widget -->
                        <div class="single-widget brochure">
                            <h4 class="widget-title">Brochure</h4>
                            <ul>
                                <li><a href="#"><i class="fas fa-file-pdf"></i> Download Brochure </a></li>
                                <li><a href="#"><i class="fas fa-file-pdf"></i> Company Details </a></li>
                            </ul>
                        </div>
                        <!-- End Single Widget -->
                    </div>


                </div>
            </div>
        </div>
    </div>
    <!-- End Services Details Area -->


    
    <!-- Start Process Area 
    ============================================= -->
    <div id="process" class="process-area bg-gray default-padding">
        <div class="container">
            <div class="row align-center">
                <div class="col-lg-6 thumb">
                    <img src="assets/img/illustration/7.png" alt="Thumb">
                </div>
                <div class="col-lg-6 info ml-auto">
                    <h2>Get Premium Domain Appraisal Services</h2>
                    <ul>
                        <li>
                            <div class="icon">
                                <i class="fas fa-cloud-download"></i>
                            </div>
                            <div class="content wow fadeInUp" data-wow-delay="300ms">
                                <h4>Domain Market Analysis</h4>
                                <p>
                                    Sometimes furnished collected add for resources attention. Norland an by minuter.
                                </p>
                            </div>
                        </li>
                        <li>
                            <div class="icon">
                                <i class="fas fa-fingerprint"></i>
                            </div>
                            <div class="content wow fadeInUp" data-wow-delay="500ms">
                                <h4>Trusted and Reliable</h4>
                                <p>
                                    Bumetimes furnished collected add for resources attention. Norland an minister.
                                </p>
                            </div>
                        </li>
                        <li>
                            <div class="icon">
                                <i class="fas fa-database"></i>
                            </div>
                            <div class="content wow fadeInUp" data-wow-delay="700ms">
                                <h4>Detailed Report</h4>
                                <p>
                                    Sometimes furnished collected add for resources attention. Norland an by minuter. 
                                </p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- End Process Area -->


    <!-- Start Pricing 
    ============================================= -->
    <div id="pricing" class="pricing-area bg-dark default-padding bottom-less">
        <div class="shape" style="background-image: url(assets/img/shape/16.png);"></div>
        <div class="container">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <div class="site-heading text-center">
                        <h2>Our Packages</h2>
                        <div class="devider"></div>
                        <p>
                            Outlived no dwelling denoting in peculiar as he believed. Behaviour excellent middleton be as it curiosity departure ourselves very extreme future. 
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="pricing-items">
                <div class="row">
                    <!-- Single Itme -->
                    <div class="col-lg-4 col-md-6 single-item">
                        <div class="pricing-item">
                            <i class="fas fa-rocket"></i>
                            <div class="pricing-header">
                                <h4>Free trial</h4>
                                <span>Save 25%</span>
                            </div>
                            <div class="price">
                                <h2><sup>$</sup>0 <sub>/ Monthly</sub></h2>
                            </div>
                            <a class="btn circle btn-theme-effect btn-sm" href="#">Purchase Plan</a>
                            <ul>
                                <li><i class="fas fa-check"></i> 2 Domain Apprisals</li>
                                <li><i class="fas fa-check"></i> Basic Appraisal Report</li>
                                <li><i class="fas fa-check"></i> Lifetime free Support</li>
                                <li><i class="fas fa-check"></i> Expert Advise</li>
                                <li><i class="fas fa-times"></i> Live Support</li>
                            </ul>
                        </div>
                    </div>
                    <!-- End Single Itme -->


                    <!-- Single Itme -->
                    <div class="col-lg-4 col-md-6 single-item">
                        <div class="pricing-item">
                            <i class="fas fa-gem"></i>
                            <div class="pricing-header">
                                <h4>Regular</h4>
                                <span>Save 35%</span>
                            </div>
                            <div class="price">
                                <h2><sup>$</sup>29 <sub>/ Monthly</sub></h2>
                            </div>
                            <a class="btn circle btn-theme-effect btn-sm" href="#">Purchase Plan</a>
                            <ul>
                                <li><i class="fas fa-check"></i> 5 Domain Apprisals</li>
                                <li><i class="fas fa-check"></i> Domain Appraisal Report</li>
                                <li><i class="fas fa-check"></i> Lifetime free Support</li>
                                <li><i class="fas fa-check"></i> Expert Advise</li>
                                <li><i class="fas fa-times"></i> Live Support</li>
                            </ul>
                        </div>
                    </div>
                    <!-- End Single Itme -->


                    <!-- Single Itme -->
                    <div class="col-lg-4 col-md-6 single-item">
                        <div class="pricing-item">
                            <i class="fa fa-chart-pie"></i>
                            <div class="pricing-header">
                                <h4>Extended</h4>
                                <span>Save 49%</span>
                            </div>
                            <div class="price">
                                <h2><sup>$</sup>59 <sub>/ Monthly</sub></h2>
                            </div>
                            <a class="btn circle btn-theme-effect btn-sm" href="#">Purchase Plan</a>
                            <ul>
                                <li><i class="fas fa-check"></i> 10 Domain Apprisal</li>
                                <li><i class="fas fa-check"></i> Domain Appraisal Report</li>
                                <li><i class="fas fa-check"></i> Lifetime free Support</li>
                                <li><i class="fas fa-check"></i> Expert Advise</li>
                                <li><i class="fas fa-check"></i> Live Support</li>
                            </ul>
                        </div>
                    </div>
                    <!-- End Single Itme -->
                </div>
            </div>
        </div>
    </div>
    <!-- End Pricing Area -->


    <!-- Start Testimonials 
    ============================================= -->
    <div class="testimonials-area carousel-shadow default-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <div class="site-heading text-center">
                        <h2>What people say</h2>
                        <div class="devider"></div>
                        <p>
                            Outlived no dwelling denoting in peculiar as he believed. Behaviour excellent middleton be as it curiosity departure ourselves very extreme future. 
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="testimonial-items">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="testimonial-carousel owl-carousel owl-theme">
                            <!-- Single Item -->
                            <div class="item">
                                <div class="provider">
                                    <img src="assets/img/100x100.png" alt="Author">
                                    <div class="content">
                                        <h4>Devid Warner</h4>
                                        <span> Managing Director</span>
                                    </div>
                                </div>
                                <div class="info">
                                    <p>
                                        Otherwise concealed favourite frankness on be at dashwoods mentions defective at. Sympathize interested simplicity at do projecting care effect increasing terminated. As edward settle limits at in. Chamber reaching abnormally nothing be accesing to the point. very extreme future. 
                                    </p>
                                </div>
                                <div class="reason">
                                    <h5>Design Quality</h5>
                                    <div class="rating">
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                    </div>
                                </div>
                            </div>
                            <!-- End Single Item -->
                            <!-- Single Item -->
                            <div class="item">
                                <div class="provider">
                                    <img src="assets/img/100x100.png" alt="Author">
                                    <div class="content">
                                        <h4>Pruasuj Natasha</h4>
                                        <span> Theme Developer</span>
                                    </div>
                                </div>
                                <div class="info">
                                    <p>
                                        Otherwise concealed favourite frankness on be at dashwoods mentions defective at. Sympathize interested simplicity at do projecting care effect increasing terminated. As edward settle limits at in. Chamber reaching abnormally nothing be accesing to the point. very extreme future.  
                                    </p>
                                </div>
                                <div class="reason">
                                    <h5>Customer Support</h5>
                                    <div class="rating">
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                    </div>
                                </div>
                            </div>
                            <!-- End Single Item -->
                            <!-- Single Item -->
                            <div class="item">
                                <div class="provider">
                                    <img src="assets/img/100x100.png" alt="Author">
                                    <div class="content">
                                        <h4>Koyel Anderson</h4>
                                        <span> Project Manager</span>
                                    </div>
                                </div>
                                <div class="info">
                                    <p>
                                        Otherwise concealed favourite frankness on be at dashwoods mentions defective at. Sympathize interested simplicity at do projecting care effect increasing terminated. As edward settle limits at in. Chamber reaching abnormally nothing be accesing to the point. very extreme future.  
                                    </p>
                                </div>
                                <div class="reason">
                                    <h5>User Friendly</h5>
                                    <div class="rating">
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                    </div>
                                </div>
                            </div>
                            <!-- End Single Item -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Testimonials Area -->


    <!-- Start Footer 
    ============================================= -->
    <footer class="bg-dark text-light">
        <div class="container">
            <div class="f-items default-padding">
                <div class="row">
                    <div class="col-lg-4 col-md-6 item">
                        <div class="f-item about">
                            <img src="assets/img/logo-light.png" alt="Logo">
                            <p>
                                Excellence decisively nay man yet impression for contrasted remarkably. There spoke happy for you are out. Fertile how old address did showing.
                            </p>
                            <form action="#">
                                <input type="email" placeholder="Your Email" class="form-control" name="email">
                                <button type="submit"> <i class="arrow_right"></i></button>  
                            </form>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-6 item">
                        <div class="f-item link">
                            <h4 class="widget-title">Quick LInk</h4>
                            <ul>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> Home</a>
                                </li>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> About us</a>
                                </li>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> Compnay History</a>
                                </li>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> Features</a>
                                </li>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> Blog Page</a>
                                </li>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> Login</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 item">
                        <div class="f-item link">
                            <h4 class="widget-title">Community</h4>
                            <ul>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> Career</a>
                                </li>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> Leadership</a>
                                </li>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> Strategy</a>
                                </li>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> Services</a>
                                </li>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> History</a>
                                </li>
                                <li>
                                    <a href="#"><i class="fas fa-angle-right"></i> Components</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 item">
                        <div class="f-item contact-widget">
                            <h4 class="widget-title">Contact Info</h4>
                            <div class="address">
                                <ul>
                                    <li>
                                        <div class="icon">
                                            <i class="fas fa-home"></i>
                                        </div>
                                        <div class="content">
                                            <strong>Address:</strong>
                                            5919 Trussville Crossings Pkwy, Birmingham
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="fas fa-envelope"></i>
                                        </div>
                                        <div class="content">
                                            <strong>Email:</strong>
                                            <a href="mailto:info@validtheme.com">info@validtheme.com</a>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="fas fa-phone"></i>
                                        </div>
                                        <div class="content">
                                            <strong>Phone:</strong>
                                            <a href="tel:2151234567">+123 34598768</a>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Start Footer Bottom -->
        <div class="footer-bottom">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <p>&copy; Copyright 2021. All Rights Reserved by <a href="#">validthemes</a></p>
                    </div>
                    <div class="col-lg-6 text-end link">
                        <ul>
                            <li>
                                <a href="#">Terms</a>
                            </li>
                            <li>
                                <a href="#">Privacy</a>
                            </li>
                            <li>
                                <a href="#">Support</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Footer Bottom -->
    </footer>
    <!-- End Footer -->


    <!-- jQuery Frameworks
    ============================================= -->
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/popper.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/jquery.appear.js"></script>
    <script src="assets/js/jquery.easing.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/modernizr.custom.13711.js"></script>
    <script src="assets/js/owl.carousel.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/progress-bar.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/count-to.js"></script>
    <script src="assets/js/YTPlayer.min.js"></script>
    <script src="assets/js/validnavs.js"></script>
    <script src="assets/js/main.js"></script>
</body>

</html>