<?php

namespace App\Http\Controllers;

use App\Models\Article;
use App\Models\Package;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class HomeController extends Controller
{
    //  
    public function display(){
        $articles = Article::all()->sortByDesc("publishing_date")->take(3);
        $packages = Package::all()->sortBy("created_at")->where('public_display', '=', 1)->take(3);
        
        return view('site.home', compact('articles', 'packages'));
    }

    public function article(Request $request){
        $article = Article::findOrFail($request->id);
        
        $previous_id = Article::where('id', '<', $request->id)->max('id');
        $next_id = Article::where('id', '>', $request->id)->min('id');

        $previous_title = null;
        $next_title = null;
        if(!($previous_id == null)){
            $previous_title = Article::where('id', '=', $previous_id)->get()->toArray();    
            $previous_title = $previous_title[0]['title'];
        }
        if(!($next_id == null)){
            $next_title = Article::where('id', '=', $next_id)->get()->toArray();    
            $next_title = $next_title[0]['title'];  
        }

        return view('site.blog', compact('article', 'previous_id', 'previous_title', 'next_id', 'next_title'));
    }

    public function articles(){
        
        $articles = DB::table('articles')->orderBy('publishing_date', 'DESC')->paginate(2);
        
        return view('site.blogs', compact('articles'));
    }

    public function pricing(){
        $packages = Package::all()->sortBy("created_at")->where('public_display', '=', 1)->take(3);
        return view('site.pricing', compact('packages'));
    }

    public function premium(){
        return view('site.premium');
    }

    public function contact(){
        return view('site.contact');
    }

    public function dashboard(){
        return view('user.dashboard');
    }

    public function bulk(){
        return view('user.bulk');
    }
}
