@extends('layouts.admin.master')

@section('title') Categories @endsection

@section('content')

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="card-title">Domain Categories Table</h4>
                    <p class="card-title-desc">Lists all ENS Domain categories and their Price Points
                    </p>

                    <div class="table-responsive">
                        <table class="table table-editable table-nowrap align-middle table-edits">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Price Point</th>
                                    <th>Edit</th>
                                </tr>
                            </thead>

                            <tbody> 
                                @foreach ($domain_categories as $domain_category)
                                <tr data-id="{{$domain_category->id}}">
                                    <td>{{$domain_category->id}}</td>
                                    <td>{{$domain_category->title}}</td>
                                    <td data-field="description" data-name="description" data-pk="{{$domain_category->id}}" class="update">{{$domain_category->description}}</td>
                                    <td data-field="price_point" class="update">{{$domain_category->price_point}}</td>
                                    <td style="width: 100px">
                                        <a class="btn btn-outline-secondary btn-sm edit" title="Edit">
                                            <i class="fas fa-pencil-alt"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection
@section('script')
    <!-- Table Editable plugin -->
    <script src="{{ URL::asset('/assets/admin/libs/table-edits/table-edits.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/admin/js/pages/table-editable.int.js') }}"></script>
@endsection
