@extends('layouts.site.master')

@section('title') Appraisal @endsection

@section('content')

	<div class="breadcrumb-area shadow dark bg-cover text-center text-light" style="background-image: url({{asset('assets/site/img/articles/banner.jpg')}});">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <div class="site-heading text-center">
                        <h2>Our Packages</h2>
                        <div class="devider"></div>
                        <p>
                            Choose the one that suits you best and we can grow together. 
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
     <div id="pricing" class="pricing-area default-padding bottom-less">
        <div class="shape" style="background-image: url({{asset('assets/site/img/shape/16.png')}});"></div>
        <div class="container">
        </div>
        <div class="container">
            <div class="pricing-items">
                <div class="row">
                    <!-- Single Item -->
                    @foreach($packages as $package)
                    <div class="col-lg-4 col-md-6 single-item" >
                        <div class="pricing-item" style="border: 3px solid #202942 !important;">
                            <div class="pricing-header">
                                <h4>{{$package->name}}</h4>
                                <span>
                                @if ($package->appraisal == 2147483647) 
                                Unlimited
                                @else 
                                {{$package->appraisal}}
                                @endif
                                </span>
                            </div>
                            <div class="price">
                                <h2><sup>$</sup>{{$package->price}} <sub>/ Month</sub></h2>
                            </div>
                            <a class="btn circle btn-theme-effect btn-sm" href="#">Purchase Plan</a>
                            <ul>
                                <li>{{$package->details}}</li>
                                <br>
                                <li><i class="fas fa-check"></i> 
                                    @if($package->appraisal == 2147483647) Unlimited @else {{$package->appraisal}} @endif Domain Appraisals</li>
                                <li>
                                    @if($package->premium_support==1)<i class="fas fa-check"></i>@else<i class="fas fa-times"></i>@endif           &nbsp; Premium Support
                                </li>
                                <li>
                                    @if($package->bulk_appraisal==0)<i class="fas fa-times"></i>@else<i class="fas fa-check"></i>@endif           &nbsp; Bulk Appraisal
                                </li>
                                <li>
                                    @if($package->appraisal_certificate==0)<i class="fas fa-times"></i>@else<i class="fas fa-check"></i>@endif           &nbsp; Appraisal Certificate
                                </li>
                            </ul>
                        </div>
                    </div>
                    @endforeach
                    <!-- End Single Item -->
                </div>
            </div>
        </div>
    </div>
@endsection