<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AppraisalController;
use App\Http\Controllers\CategoryController;

use App\Models\User;
use Illuminate\Auth\Events\Registered;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'HomeController@display')->name('home');
Route::get('/blog/{id}', 'HomeController@article');
Route::get('/blog', 'HomeController@articles')->name('blog');

Route::get('/appraisal', 'AppraisalController@evaluate');
Route::get('/appraisal/{hash}', 'AppraisalController@public_appraisal');

Route::get('/categories', 'AdminController@Showcategories');
Route::post('categories/update/{id}', 'AdminController@Updatecategories');

//->middleware('verified');
Route::get('/pricing', 'HomeController@pricing')->name('pricing');
Route::get('/premium', 'HomeController@premium')->name('premium');
Route::get('/contact', 'HomeController@contact')->name('contact');
Route::get('/bulk-appraisals', 'HomeController@bulk')->name('bulk');

Route::get('/dashboard', 'HomeController@dashboard')->name('dashboard');

Route::get('/logout', function(){
    if (Auth::user()) {
    Auth::logout();

    return Redirect::home();
    }
})->name('logout');



Route::get('/mail', function(){
    //     $messageBody = "This is a check";

    // Mail::raw($messageBody, function ($message) {
    //     $message->from('no-reply@meveu.com', 'Example');
    //     $message->to('hammadr097@gmail.com');
    //     $message->subject('test email');
    // });

    // // check for failures
    // if (Mail::failures()) {
    //     // return response showing failed emails
    // }
});

require __DIR__.'/auth.php';
