

<?php $__env->startSection('title'); ?> Categories <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="card-title">Domain Categories Table</h4>
                    <p class="card-title-desc">Lists all ENS Domain categories and their Price Points
                    </p>

                    <div class="table-responsive">
                        <table class="table table-editable table-nowrap align-middle table-edits">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Price Point</th>
                                    <th>Edit</th>
                                </tr>
                            </thead>

                            <tbody> 
                                <?php $__currentLoopData = $domain_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $domain_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr data-id="<?php echo e($domain_category->id); ?>">
                                    <td><?php echo e($domain_category->id); ?></td>
                                    <td><?php echo e($domain_category->title); ?></td>
                                    <td data-field="description" data-name="description" data-pk="<?php echo e($domain_category->id); ?>" class="update"><?php echo e($domain_category->description); ?></td>
                                    <td data-field="price_point" class="update"><?php echo e($domain_category->price_point); ?></td>
                                    <td style="width: 100px">
                                        <a class="btn btn-outline-secondary btn-sm edit" title="Edit">
                                            <i class="fas fa-pencil-alt"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- Table Editable plugin -->
    <script src="<?php echo e(URL::asset('/assets/admin/libs/table-edits/table-edits.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('/assets/admin/js/pages/table-editable.int.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Arete\DAT\resources\views/admin/categories.blade.php ENDPATH**/ ?>