<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Package;
use App\Models\Appraisal;
use Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
include(app_path().'/includes/category.php');

class AppraisalController extends Controller
{
    //

    public function evaluate(Request $request){
       
        $ens = $request->domain;
        $appraisalArray = appraise($ens);

        $domain_value = $appraisalArray['domain_value'];
        $length = $appraisalArray['length'];
        $lastSalePrice = $appraisalArray['lastSalePrice'];
        $metaData = $appraisalArray['metaData'];
        $domain_categories = $appraisalArray['domain_categories'];
        $input = $appraisalArray['input'];

        //To be integrated
        $url = "some url";
        $token_id = "123456789";
        $lastSaleTime = date("Y-m-d", substr($metaData["attributes"][0]['value'], 0, 10));
        //

        //if auth, get user id
        $user_id = 0;
        if(Auth::check()){
            $user_id = Auth::user()->id;
        }
        //split domain categories
        //last sale time
        //public link hash
        //$public_link = Str::random(4).'-'.Str::random(4).'-'.Str::random(4).'-'.Str::random(4);
        $public_link = md5(time());
        $appraisal = Appraisal::create([
            'user_id' => $user_id,
            'domain_name' => $ens,
            'value' => $domain_value,
            'domain_categories' => 'placeholder',
            'creation_date' => date("Y-m-d", substr($metaData["attributes"][0]['value'], 0, 10)),
            'registration_date' => date("Y-m-d", substr($metaData["attributes"][4]['value'], 0, 10)),
            'expiry_date' => date("Y-m-d", substr($metaData["attributes"][5]['value'], 0, 10)),
            'last_sale_price' => $lastSalePrice,
            'last_sale_time' => $lastSaleTime,
            'public_link' => $public_link,
            'appraisal_time' => date('Y-m-d H:i:s'),
            'token_id' => $token_id,
            'url' => $url, 
        ]);
        $appraisal->save();

        $packages = Package::all()->sortBy("created_at")->where('public_display', '=', 1)->take(3);

        return view('site.appraisal',compact('domain_value', 'length', 'lastSalePrice', 'metaData', 'domain_categories', 'input', 'packages'));

        
    }

    public function public_appraisal(Request $request){
        $appraisal = DB::table('appraisal_history')->where('public_link', $request->hash)->get()->toArray();
        
        dd($appraisal);

    }

}

