<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Subscription;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Carbon\Carbon;
class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
        ]);

        $current = Carbon::now();
        $expiry = $current->addDays(30);
        $Subscription = Subscription::create([
            'user_id' => $user->id,
            'package_id' => 4,
            'subscription_time' => Carbon::now(),
            'expiry_date' => $expiry,
            'total_appraisals' => 10,
            'remaining_appraisals' => 0,
            'subscription_autorenew' => 0,
            'payment_mode' => 0,
            'payment_id' => 0,
        ]);
        Auth::login($user);

        

        event(new Registered($user));



        


        

        return redirect(RouteServiceProvider::HOME);
    }
}
