<?php

namespace App\Http\Controllers;

use App\Models\Article;
use App\Models\Package;
use App\Models\Appraisal;
use App\Models\Subscription;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Hash;
use Auth;
class HomeController extends Controller
{
    //  
    public function display(){
        $articles = Article::all()->sortByDesc("publishing_date")->take(3);
        $packages = Package::all()->sortBy("created_at")->where('public_display', '=', 1)->take(3);
        
        return view('site.home', compact('articles', 'packages'));
    }

    public function article(Request $request){
        $article = Article::findOrFail($request->id);
        
        $previous_id = Article::where('id', '<', $request->id)->max('id');
        $next_id = Article::where('id', '>', $request->id)->min('id');

        $previous_title = null;
        $next_title = null;
        if(!($previous_id == null)){
            $previous_title = Article::where('id', '=', $previous_id)->get()->toArray();    
            $previous_title = $previous_title[0]['title'];
        }
        if(!($next_id == null)){
            $next_title = Article::where('id', '=', $next_id)->get()->toArray();    
            $next_title = $next_title[0]['title'];  
        }

        return view('site.blog', compact('article', 'previous_id', 'previous_title', 'next_id', 'next_title'));
    }

    public function articles(){
        
        $articles = DB::table('articles')->orderBy('publishing_date', 'DESC')->paginate(2);
        
        return view('site.blogs', compact('articles'));
    }

    public function pricing(){
        $packages = Package::all()->sortBy("created_at")->where('public_display', '=', 1)->take(3);
        return view('site.pricing', compact('packages'));
    }

    public function premium(){
        return view('user.premium');
    }

    public function contact(){
        return view('site.contact');
    }

    public function dashboard(){
        $recent_appraisals = Appraisal::all()->sortByDesc("appraisal_time")->where('user_id', '=', Auth()->user()->id)->take(3);
        $subscription = Subscription::where('user_id', '=', Auth()->user()->id)->get()->first()->toArray();
        $appraisal_count = Appraisal::where('user_id', Auth()->user()->id)->count();

        return view('user.dashboard', compact('recent_appraisals', 'subscription', 'appraisal_count'));
    }

    public function bulk(){
        return view('user.bulk');
    }

    public function select_package(Request $request){
        $package_id = $request->package_id;
        $package = Package::findOrFail($package_id);
        $redirect_route = 'dashboard/billing/'.$package->name;
        return redirect($redirect_route);
    }

    public function selected_package(Request $request){
        $package = Package::where('name', '=', $request->package_name)->get()->toArray();
        if(empty($package[0])){
            abort('404');
        }
        $package = $package[0];
        
        return view('user.billing_selected', compact('package'));
    }

    public function billing_success(Request $request){
        $user_id = Auth()->user()->id;
        return view('user.billing_success');
    }

    public function appraisal_history(){
        // $appraisals = Appraisal::where('user_id', '=', Auth()->user()->id)->orderBy("appraisal_time", 'desc')->take(5)->get()->toArray();
        $appraisals = Appraisal::all()->sortByDesc("appraisal_time")->where('user_id', '=', Auth()->user()->id)->take(999999);
        
        return view('user.history', compact('appraisals'));
    }

    public function settings(){

        return view('user.settings');
    }

    public function settings_update_info(Request $request){
        $user_id = Auth()->user()->id;
        $user = User::where('id', '=', $user_id)->first();
        if($user_id == $user->id)
        {
            $user->name = $request->name;     
            $user->save();
            return redirect()->back()->with('success', 'Name successfully updated!');
        }
        //
        
            
    }

    public function settings_update_password(Request $request){
        
        Hash::check('123456a','$2y$10$.XB30GO4jn7bx7EauLrWkugIaCNGxiQCgrFTeFDeSSrGdQYd6Rneq');
        if (!(Hash::check($request->get('current-password'), Auth::user()->password))) {
            return redirect()->back()->with("error","Incorrect Password Entered!");
        }
        if(strcmp($request->get('current-password'), $request->get('new-password')) == 0){
            // Current password and new password same
            return redirect()->back()->with("error","New Password cannot be same as your current password.");
        }

        $validatedData = $request->validate([
            'current-password' => 'required',
            'new-password' => 'required|string|min:8|confirmed',
        ]);

        // //Change Password
        $user = Auth::user();
        $user->password = bcrypt($request->get('new-password'));
        $user->save();

        return redirect()->back()->with("success","Password successfully changed!");
        
            
    }

    public function domain_appraisal(){
        return view('user.domain_appraisal');
    }

    public function bulk_report(Request $request){
        $domains_array = explode(PHP_EOL, $request->get('domains'));
        $domains_list = implode(', ', $domains_array);

        return view('user.bulk_report', compact('domains_list'));
    }


   
}
