function timestamptoDate(timestamp){
	var date = new Date(timestamp);
	return date.getDate()+"/"+(date.getMonth()+1)+"/"+date.getFullYear();
}

var price = 0;
function lastSale(item, index){
	if(item['type'] == 'sale'){
		if(activitiesArray[index]['price'] > price){
			price = activitiesArray[index]['price'];
			return price;
		}
	}
}

async function resolveMetadata(ens){
	ens = ens.slice(0, -4);
	const BigNumber = ethers.BigNumber
	const utils = ethers.utils
	const labelHash = utils.keccak256(utils.toUtf8Bytes(ens))
	const tokenId = BigNumber.from(labelHash).toString()

	var priceUrl = 'https://api.reservoir.tools/tokens/0x57f1887a8BF19b14fC0dF6Fd9B2acc9Af147eA85:'+tokenId+'/activity/v1?limit=10';
	let priceResponse = await fetch(priceUrl);
	let priceData = await priceResponse.json();
	var activities = priceData['activities'];
	activitiesObject = Object.entries(activities);
	activitiesArray = activitiesObject.flat();
	activitiesSale = activitiesArray.filter(lastSale);
	
	if(activitiesSale.length > 0){
		price = activitiesSale[0]['price'];
		var lastSaleHtml = '<div class="col-lg-6 col-md-6"><div class="item"><h4><a href="#">Last Sale</a></h4><p>'+price+'<img src="./assets/ethereum-eth-logo.png" style="width: 16px;"></p></div></div>'
		$( "#domain-value" ).after(lastSaleHtml);
	}

	var metaUrl = 'https://metadata.ens.domains/mainnet/0x57f1887a8BF19b14fC0dF6Fd9B2acc9Af147eA85/'+tokenId+'/';
	let metaResponse = await fetch(metaUrl);
	let metaData = await metaResponse.json();
	var createdDate = metaData['attributes'][0]['value'];
	var registrationDate = metaData['attributes'][4]['value'];
	var expirationDate = metaData['attributes'][5]['value'];

	createdDate = timestamptoDate(createdDate);
	registrationDate = timestamptoDate(registrationDate);
	expirationDate = timestamptoDate(expirationDate);

	var createdDateHtml = '<div class="col-lg-6 col-md-6"><div class="item"><h4><a href="#">Created On</a></h4><p>'+createdDate+'</p></div></div>';
	var registrationDateHtml = '<div class="col-lg-6 col-md-6"><div class="item"><h4><a href="#">Registration Date</a></h4><p>'+registrationDate+'</p></div></div>';
	var expirationDateHtml = '<div class="col-lg-6 col-md-6"><div class="item"><h4><a href="#">Expiration Date</a></h4><p>'+expirationDate+'</p></div></div>';
	$( "#domain-value" ).after(createdDateHtml+registrationDateHtml+expirationDateHtml);
}

var domainName = $( "#domain-name" ).text();
resolveMetadata(domainName);