
@extends('layouts.user.master-auth')
@section('title') Login @endsection
@section('content')
<section class="md:h-screen py-36 flex items-center bg-no-repeat bg-center" style="background: url('{{asset("assets/user/images/bg/login.jpg")}}') no-repeat center center / cover">
            <div class="absolute inset-0 bg-gradient-to-b from-transparent to-black"></div>
            <div class="container">
                <div class="flex justify-center">
                    <div class="max-w-[400px] w-full m-auto p-6 bg-white dark:bg-slate-900 shadow-md dark:shadow-gray-800 rounded-md">
                        <a href="{{route('home')}}"><img src="{{asset('assets/logo.png')}}" class="mx-auto" alt="" width="200"></a>
                        <h5 class="my-6 text-2xl font-bold text-indigo-600">Verify Email</h5>
                            <div>
                                <div class="mb-4 text-sm text-gray-600">
                                        {{ __('Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you? If you didn\'t receive the email, we will gladly send you another.') }}
                                </div>
                                @if (session('status') == 'verification-link-sent')
                                        <div class="mb-4 font-medium text-sm text-green-600">
                                            {{ __('A new verification link has been sent to the email address you provided during registration.') }}
                                        </div>
                                    @endif
                                    <div class="mt-4 flex items-center justify-between">
                                        <form method="POST" action="{{ route('verification.send') }}">
                                            @csrf

                                            <div>
                                                <x-button>
                                                    {{ __('Resend Verification Email') }}
                                                </x-button>
                                            </div>
                                        </form>

                                        <form method="POST" action="{{ route('logout') }}">
                                            @csrf

                                            <button type="submit" class="underline text-sm text-gray-600 hover:text-gray-900">
                                                {{ __('Log Out') }}
                                            </button>
                                        </form>
                                    </div>
                            </div>
                    </div>
                </div>
            </div>
        </section><!--end section -->
        <!-- Switcher -->
        <div class="fixed top-1/4 -right-1 z-3">
            <span class="relative inline-block rotate-90">
                <input type="checkbox" class="checkbox opacity-0 absolute" id="chk" />
                <label class="label bg-slate-900 dark:bg-white shadow dark:shadow-gray-800 cursor-pointer rounded-full flex justify-between items-center p-1 w-14 h-8" for="chk">
                    <i class="uil uil-moon text-[20px] text-yellow-500"></i>
                    <i class="uil uil-sun text-[20px] text-yellow-500"></i>
                    <span class="ball bg-white dark:bg-slate-900 rounded-full absolute top-[2px] left-[2px] w-7 h-7"></span>
                </label>
            </span>
        </div>
        <!-- Switcher -->
        <!-- JAVASCRIPTS -->
        <script src="{{asset('assets/user/libs/feather-icons/feather.min.js')}}"></script>
        <script src="{{asset('assets/user/js/plugins.init.js')}}"></script>
        <script src="{{asset('assets/user/js/app.js')}}"></script>
@endsection
