<!DOCTYPE html>
<html lang="en" class="light scroll-smooth" dir="ltr">    
    <head>
        <title> @yield('title') | Domain Appraisal Tool</title>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="DAT - Prototype - Domain Appraisal Tool">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <!-- favicon -->
        <link rel="shortcut icon" href="{{asset('assets/site/img/favicon.png')}}" type="image/x-icon">
        @include('layouts.user.head-css')
    </head>
    <body class="font-nunito text-base text-black dark:text-white dark:bg-slate-900">
        @include('layouts.user.header')
        <section class="relative lg:pb-24 pb-16">
            <div class="container-fluid">
                <div class="profile-banner relative text-transparent">
                    <input id="pro-banner" name="profile-banner" type="file" class="hidden" onchange="loadFile(event)" />
                    <div class="relative shrink-0">
                        <img src="{{asset('assets/user/images/blog/bg.jpg')}}" class="h-80 w-full object-cover" id="profile-banner" alt="">
                        <div class="absolute inset-0 bg-black/70"></div>
                        <label class="absolute inset-0 cursor-pointer" for="pro-banner"></label>
                    </div>
                </div>
            </div><!--end container-->
            <div class="container lg:mt-24 mt-16">
                <div class="md:flex">
                @include('layouts.user.sidebar')
                @yield('content')
                </div>
            </div>
        </section>  
        @include('layouts.user.footer')
    </body>
</html>