@extends('layouts.site.master')

@section('title') Home @endsection

@section('content')

    <!-- Start Breadcrumb 
    ============================================= -->
    <div class="breadcrumb-area shadow dark bg-cover text-center text-light" style="background-image: url({{asset('assets/site/img/articles/banner.jpg')}});">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <h1>{{$article->description}}</h1>
                    
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb -->

    <!-- Start Blog
    ============================================= -->
    <div class="blog-area single full-blog full-blog default-padding">
        <div class="container">
            <div class="blog-items">
                <div class="row">
                    <div class="blog-content wow fadeInUp col-lg-10 offset-lg-1 col-md-12">
                        <div class="item">

                            <div class="blog-item-box">
                                
                                <div class="thumb">
                                    <a href="#"><img src='{{ asset("assets/site/img/articles/1500x800/$article->picture") }}' alt="Thumb"></a>
                                    <div class="date"><strong>{{\Carbon\Carbon::parse($article->publishing_date)->format('d')}}</strong> <span>{{\Carbon\Carbon::parse($article->publishing_date)->format('M')}}</span></div>
                                </div>
                                <div class="info">
                                    <div class="meta">
                                        <ul>
                                            <li>
                                                <a href="#"><i class="fas fa-user"></i> {{$article->author_name}}</a>
                                            </li>
                                        </ul>
                                    </div>
                                    <h3>
                                        <a href="#">{{$article->title}}</a>
                                    </h3>
                                    <p>
                                        {!! $article->content !!}
                                    </p>
                                    

                                    
                                </div>
                            </div>
                        </div>

                        <!-- Start Post Pagination -->
                        <div class="post-pagi-area">
                            @if(!($previous_id == null))
                            <a href="{{url('/blog/'.$previous_id)}}" style="float: left;">
                                <i class="fas fa-angle-double-left"></i> Previous Post
                                <h5>{{$previous_title}}</h5>
                            </a>
                            @else
                            <a href="{{url('/blog/')}}" style="float: left;">
                                View all blogs 
                            </a>
                            @endif
                            
                            @if(!($next_id == null))
                            <a href="{{url('/blog/'.$next_id)}}" style="float: right;">
                                Next Post <i class="fas fa-angle-double-right"></i>
                                <h5>{{$next_title}}</h5>
                            </a>
                            @else
                            <a href="{{url('/blog/')}}" style="float: right;">
                                View all blogs 
                            </a>
                            @endif
                        </div>
                        <!-- End Post Pagination -->


                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Blog -->


@endsection