@extends('layouts.site.master')

@section('title') Blogs @endsection

@section('content')

<div class="breadcrumb-area shadow dark bg-cover text-center text-light" style="background-image: url({{asset('assets/site/img/articles/banner.jpg')}});">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <h1>Blog Articles</h1>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb -->

    <!-- Start Blog
    ============================================= -->
    <div class="blog-area full-blog blog-standard full-blog grid-colum default-padding">
        <div class="container">
            <div class="blog-items">
                <div class="blog-content">
                    <div class="blog-item-box" >
                        <div class="row">
                            <!-- Single Item -->
                            @foreach($articles as $article)
                            <div class="col-lg-6 col-md-6 single-item">
                                <div class="item">
                                    <div class="thumb">
                                        <a href="{{url('/blog/'.$article->id)}}"><img src='{{ asset("assets/site/img/articles/800x600/$article->picture") }}' alt="Thumb"></a>
                                        <div class="date"><strong>{{\Carbon\Carbon::parse($article->publishing_date)->format('d')}}</strong> <span>{{\Carbon\Carbon::parse($article->publishing_date)->format('M')}}</span></div>
                                    </div>
                                    <div class="info">
                                        <div class="meta">
                                            <ul>
                                                <li>
                                                    <a href="{{url('/blog/'.$article->id)}}"><i class="fas fa-user"></i>{{$article->author_name}}</a>
                                                </li>
                                            </ul>
                                        </div>
                                        <h3>
                                            <a href="{{url('/blog/'.$article->id)}}">{{$article->title}}</a>
                                        </h3>
                                        <p>
                                            {{$article->description}}
                                        </p>
                                        <a class="btn circle btn-theme-border btn-sm" href="{{url('/blog/'.$article->id)}}">Read More</a>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                            <!-- End Single Item -->
                            
                        </div>
                        
                        <!-- Pagination -->
                        <div>{{ $articles->links() }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Blog -->

@endsection