@extends('layouts.user.master')

@section('title') Dashboard @endsection

@section('content')

<div class="lg:w-3/4 md:w-2/3 md:px-3 mt-[30px] md:mt-0">
                        <div class="rounded-md shadow dark:shadow-gray-800 bg-white dark:bg-slate-900">
                            <div class="p-6 md:flex justify-between items-center border-b border-gray-100 dark:border-gray-700">
                                <div class="mb-4 md:mb-0">
                                    <h5 class="text-xl font-semibold">Selected Plan: {{$package['name']}} </h5>
                                </div>
                                <!-- <a href="#" class="btn bg-indigo-600 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white rounded-md">Switch to Annual Plan</a> -->
                            </div>

                            <div class="p-6">
                                <h5 class="text-2xl font-bold">${{$package['price']}}/Monthly</h5>
                                <p class="text-slate-400 mt-2">{{$package['details']}}</p>
                                <p class="text-slate-400 mt-2"><b>Package Features:</b></p>
                                <ul>
                                	<li>Appraisal Request Limit: {{$package['appraisal']}}</li>
                                	@if($package['bulk_appraisal'] == 1)
                                	<li>Bulk Appraisal</li>
                                	@endif
                                	@if($package['premium_support'] == 1)
                                	<li>Premium Support</li>
                                	@endif
                                	@if($package['appraisal_certificate'] == 1)
                                	<li>Appraisal Certificate</li>
                                	@endif
                                </ul>
                                <!-- <p class="text-slate-400 mt-2">Your next monthly charge of {{$package['name']}} will be applied to your primary payment method on July 20, 2022.</p> -->
                            </div>
                        </div>

                        <div class="rounded-md shadow dark:shadow-gray-800 bg-white dark:bg-slate-900 mt-6">
                            <div class="p-6 border-b border-gray-100 dark:border-gray-700">
                                <h5 class="text-xl font-semibold">Payment</h5>
                                <p class="text-slate-400 mt-2">Confirm your chosen package details below and choose a payment method</p>
                            </div>

                            <div class="px-6">
                                <ul>
                                    <li class="flex justify-between items-center py-6">
                                        <div class="flex items-center">
                                            
                                            <div class="ml-3">
                                                <p class="font-semibold">Price: ${{$package['price']}}</p>
                                                <p class="text-slate-400 text-sm">Expires in @php $validity = '+'.$package['validity'].' days';  echo $NewDate=Date('y/m/d', strtotime($validity)); @endphp</p>
                                            </div>
                                        </div>

                                        <!-- <div>
                                            <a href="#" class="btn btn-icon bg-red-600/5 hover:bg-red-600 border-red-600/10 hover:border-red-600 text-red-600 hover:text-white rounded-full"><i data-feather="trash-2" class="h-4 w-4"></i></a>
                                        </div> -->
                                    </li>

                                    

                                    <li class="py-6 border-t border-gray-100 dark:border-gray-700">
                                        <a href="#" data-modal-toggle="paymentMethod" class="btn bg-indigo-600 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white rounded-md">Stripe</a>
                                        <a href="#" data-modal-toggle="paymentMethod" class="btn bg-indigo-600 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white rounded-md">Utrust</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

@endsection