@extends('layouts.user.master-no-sidebar')

@section('title') Bulk Appraisals Report @endsection

@section('content')

@section('styles') @endsection

<!-- Start Hero -->
        <section class="relative table w-full pt-28 pb-16 lg:py-32 bg-no-repeat bg-center" style="background: url({{asset('assets/user/images/bg/bulk-appraisal-report.jpg')}}) no-repeat center center / cover" >
            <div class="absolute inset-0 bg-black opacity-80"></div>
            <div class="container">
                <div class="grid grid-cols-1 pb-8 text-center mt-12">
<!--                    <h3 class="md:text-4xl text-3xl md:leading-normal tracking-wide leading-normal font-medium text-white">Bulk Appraisal</h3>-->
                </div><!--end grid-->
            </div><!--end container-->

            <div class="absolute text-center z-10 bottom-5 right-0 left-0 mx-3">
                <ul class="breadcrumb tracking-[0.5px] breadcrumb-light mb-0 inline-block">
                   
                   <li class="inline breadcrumb-item uppercase text-[13px] font-bold duration-500 ease-in-out text-white/50 hover:text-white"><a href="{{route('bulk')}}">Bulk Appraisal</a></li>
                    <li class="inline breadcrumb-item uppercase text-[13px] font-bold duration-500 ease-in-out text-white" aria-current="page">Report</li>
                </ul>
            </div>
        </section><!--end section-->
        <div class="relative">
            <div class="shape overflow-hidden text-gray-50 dark:text-slate-800">
                <svg viewBox="0 0 2880 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M0 48H1437.5H2880V0H2160C1442.5 52 720 0 720 0H0V48Z" fill="currentColor"></path>
                </svg>
            </div>
        </div>
        <!-- End Hero -->

        <!-- Start Section-->
        <section class="relative md:py-24 py-16 md:pt-12 pt-12 bg-gray-50 dark:bg-slate-800">
            <div class="container">
                <div class="grid md:grid-cols-1 sm:grid-cols-1 grid-cols-1 gap-[30px]">
                    <img src="{{asset('assets/user/images/skeleton.gif')}}" class="loading-gif" style="width: 100%; height: 25vh">
                   	<div class="results_div"></div>
                  
                   
                    
                    
                </div><!--end grid-->
            </div><!--end container-->

            
        </section><!--end section-->
        <!-- End Section-->

@endsection

@section('scripts')
<script src="https://code.jquery.com/jquery-2.2.4.min.js" integrity="sha256-BbhdlvQf/xTY9gja0Dq3HiwQF8LaCRTXxZKRutelT44=" crossorigin="anonymous"></script>
		<script>
			
			var totalDomains=0;
			var currentDomainI=0;
			
			
			function getDomainDetails(domain,currentDomainI){
				//$('.loading-gif').show();
				$.ajax({
						//headers: { "Accept": "application/json"},
						type: "GET",
						dataType: 'json',
						crossDomain: true,
						url: 'https://dat.meveu.com/domain-appraisal.php?domain='+domain,
						async: false,
						success: function(data)
						{
							//alert(data.toString);
							//console.log("Response: " + toString(data));
							if (!data.name) 
							{ //If fails
								
								 ;
								$('.results_div').fadeIn(1000).prepend('<div style="padding: 8px; color: #dc2626; background-color: rgba(219, 38, 38, 0.05); border: 1px solid rgba(219, 38, 38, 0.05); border-radius: 6px; text-align: left; font-size: 16px; font-weight: 600;"> <strong>Warning:</strong> '+domain+' - '+data.error+'</div>'); //Throw relevant error
								
								if (currentDomainI === totalDomains - 1) {
									$('.loading-gif').slideUp(500);
								}
							}
							else 
							{
								//$('.loading-gif').slideUp(500);
								// $("#statusImg").hide();
								var domain_value="";
								var domain_length="";
								var domain_url="#";
								var domain_last_sale_price="";
								var domain_last_sale_time="";
								var domain_creation_date="";
								var domain_registration_date="";
								var domain_expiry_date="";
								var domain_categories="";

								if(data.value)
									domain_value='<div class="absolute top-6 right-6"><a class="btn btn-md bg-amber-500 hover:bg-indigo-700 border-red-600 hover:border-indigo-600 text-white hover:text-white rounded-md py-1 px-2 text-1xl"><img src="{{asset('assets/user/images/ether.svg')}}" class="w-4 h-4 inline-block text-white"> '+ data.value +' </a></div>';

								if(data.url)
									domain_url=data.url;

								if(data.creation_date)
									domain_creation_date='<li class="flex items-center mr-6"> <span class="uil  uil-clock"> Creation Date: &nbsp; </span> <b class="text-md leading-none mr-2 text-slate-900 dark:text-white"> '+ data.creation_date +'</b> </li>';

								if(data.registration_date)
									domain_registration_date='<li class="flex items-center mr-6 ml-4"> <span class="uil uil-clock"> Registration Date: &nbsp; </span> <b class="text-md leading-none mr-2 text-slate-900 dark:text-white"> '+ data.registration_date +'</b> </li>';

								if(data.expiration_date)
									domain_expiry_date='<li class="flex items-center ml-4"> <span class="uil  uil-clock "> Expiry Date: &nbsp; </span> <b class="text-mb leading-none mr-2 text-slate-900 dark:text-white"> '+ data.expiration_date +'</b> </li>';

								if(data.last_sale_price)
									domain_last_sale_price='<span class="text-slate-900 ml-6 dark:text-slate-400"><i class="uil uil-fire text-indigo-600 mr-1"></i>Last Sale Price: <strong class="dark:text-white"><img src="{{asset('assets/user/images/ether-black.svg')}}" class="w-4 h-4 inline-block"> '+data.last_sale_price+' <span class="text-slate-900 dark:text-slate-400 font-medium">on</span> '+data.last_sale_time+'</strong></span>';

								if(data.categories)
								{
									domain_categories='';
									jQuery.each( data.categories, function( i, domain ) {
										domain_categories+='<a class="bg-gray-100 dark:bg-gray-800  text-slate-400  text-xs font-medium px-3 py-1 rounded-lg h-[24px] inline-block mx-1 shadow-sm dark:shadow-gray-800">'+domain.category_name+'</a>';

									});

								}

								var newElement='<div class="group relative p-6 rounded-md shadow dark:shadow-gray-800 hover:shadow-md dark:hover:shadow-gray-700 bg-white dark:bg-slate-900 transition duration-500 my-6"><div class="mt-3"><div class="mt-1"> <a href="'+ domain_url +'" target="_blank" class="text-2xl font-medium hover:text-indigo-600 transition duration-500 block"><strong>'+ data.name +'</strong> <span class="uil uil-link h-4 w-4 inline-block ml-1 text-indigo-600 dark:text-gray-800"></span></a></div></div><div class="flex justify-between  my-4"><span class="text-slate-900 mr-6 dark:text-slate-400"><i class="uil uil-ruler text-indigo-600 mr-1 dark:text-gray-800"></i>Length: <strong class="dark:text-white">'+data.length+'</strong></span>'+ domain_last_sale_price +' <span>'+ domain_categories +'</span></div><ul class="pt-4 mt-4 border-t border-gray-100 dark:border-gray-800 flex items-center list-none text-slate-400">'+ domain_creation_date + domain_registration_date + domain_expiry_date + '</ul> '+ domain_value +'</div>';

								$('.results_div').fadeIn(500).prepend(newElement);
								
								//$('.loading-gif').fadeOut();
								//alert(currentDomainI +"==="+ (totalDomains - 1));
								
								if (currentDomainI === totalDomains - 1) {
									$('.loading-gif').slideUp(500);
								}

							}
						},
						error: function(data)
						{
							//$('#message-box').removeClass('hide');
							//$('#message-box').addClass('show');
							// $('.message-box').show();
	
							// $("#statusImg").hide();
							
							var msg = "Sorry but there was an error: ";
				console.log("Response: " + data.error);
							 //$('.results_div').fadeIn(1000).append('<p>' +data.errors.query +'</p>'); //Throw relevant error
							
							if (currentDomainI === totalDomains - 1) {
									$('.loading-gif').slideUp(500);
								}
						}
				   });
					
			}
			
			var domains_list = {!! json_encode($domains_list) !!};
			var domains_array = domains_list.split(',');
			var domains = domains_array;

			totalDomains=domains.length;
			
			//$(window).load( function( response, status, xhr ) {
				
//			  if ( status == "error" ) {
//				var msg = "Sorry but there was an error: ";
//				alert( msg + xhr.status + " " + xhr.statusText );
//			  }
			//});

			//var domains = [ "taimur.eth"];
			$(window).load(function()
			{//alert("Starting");
				
				jQuery.each( domains, function( i, domain )
				{
				  	//alert( "#" + i + "Domain is  " + val + "." );
					//$('.loading-gif').show();
		          
					setTimeout( function(){ getDomainDetails(domain,i); }, i * 1000)

					currentDomainI=i;
       
				});

				//$('.loading-gif').fadeOut();
			});
		</script>
@endsection