@extends('layouts.user.master-no-sidebar')

@section('title') Premium Appraisal @endsection

@section('styles') @endsection

@section('content')

<!-- Start Hero -->
        <section class="relative table w-full py-32 lg:py-40 " style="background: url('{{asset("assets/user/images/bg/premium-appraisal-1.jpg")}}') no-repeat center center / cover">
           <div class="absolute inset-0 bg-black opacity-80"></div>
            <div class="container">
                <div class="grid grid-cols-1 text-center mt-10">
                    <h3 class="text-3xl leading-normal font-medium text-white">Premium Appraisal</h3>
                </div><!--end grid-->
            </div><!--end container-->
            
            <div class="absolute text-center z-10 bottom-5 right-0 left-0 mx-3">
                <ul class="breadcrumb tracking-[0.5px] breadcrumb-light mb-0 inline-block">
                    <li class="inline breadcrumb-item uppercase text-[13px] font-bold duration-500 text-white/50 ease-in-out hover:text-indigo-600"><a href="./">Domain Appraisal Tool</a></li>
                    <li class="inline breadcrumb-item uppercase text-[13px] font-bold duration-500 text-white/50 ease-in-out hover:text-indigo-600"><a href="#">Premium Appraisal</a></li>
                    <li class="inline breadcrumb-item uppercase text-[13px] font-bold hover:text-indigo-600  text-white" aria-current="page">Submit Request</li>
                </ul>
            </div>
        </section><!--end section-->
        <div class="relative">
            <div class="shape overflow-hidden z-1 text-white dark:text-slate-900">
                <svg viewBox="0 0 2880 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M0 48H1437.5H2880V0H2160C1442.5 52 720 0 720 0H0V48Z" fill="currentColor"></path>
                </svg>
            </div>
        </div>
        <!-- End Hero -->

        <!-- Start -->
        <section class="relative md:py-24 py-16">
            <div class="container">
                <div class="md:flex p-6 bg-white dark:bg-slate-900 rounded-md shadow dark:shadow-gray-800">
                    <div class="lg:w-1/3 md:w-2/5">
                       <h3 class="font-bold text-2xl text-indigo-600 mb-4">Premium Services</h3>
                        <p class="font-semibold mb-6">ENS domain appraisal can consist of a lot more than valuation. We provide extended features and premium services to our ‘Pro’ users. Depending on what you need you can choose the package that suits your needs best. It’s seamless to upgrade, so as you grow, our features will grow with you.</p>
                        <div class="preview-box flex justify-center rounded-md shadow dark:shadow-gray-800 overflow-hidden bg-gray-50 dark:bg-slate-800 text-slate-400 p-2 text-center small">With the Live Support option you will have a dedicated collector manager at your disposal. </div>
                        
                        <a href="https://t.co/n5gMPPAfoA" target="_blank"><label class="btn-upload btn bg-amber-500 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white rounded-md w-half mt-6 cursor-pointer" for="input-file">Let's Connect on Discord</label></a>
                    </div>

                    <div class="lg:w-2/3 md:w-3/5 mt-8 md:mt-0">
                        <div class="md:ml-6">
                            <form>
                                <div class="grid grid-cols-12 gap-6">
                                    <div class="col-span-12">
                                        <label class="font-semibold">Domain Name <span class="text-red-600">*</span></label>
                                        <input name="name" id="name" type="text" class="form-input mt-2" placeholder=".eth Domain Name">
                                    </div><!--end col-->
                                    
                                    <div class="md:col-span-12 col-span-12">
                                        <label class="font-semibold">Purpose :</label>
                                        <select class="form-input mt-2">
                                            <option value="Buy">Buy</option>
                                            <option value="Sell">Sell</option>
                                            <option value="Mint">Mint</option>
                                            <option value="Other">Other</option>
                                        </select>
                                    </div><!--end col-->

                                    <div class="col-span-12">
                                        <label class="font-semibold"> Notes/Comments : </label>
                                        <textarea name="comments" id="comments" class="form-input mt-2 h-28" placeholder="Comments or Instructions for the appraiser"></textarea>
                                    </div><!--end col-->

                                    


                                    <div class="col-span-12">
                                        <button type="submit" class="btn bg-indigo-600 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white rounded-md">Submit</button>
                                    </div><!--end col-->
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div><!--end container-->
        </section><!--end end section-->
        <!-- End -->


@endsection

@section('scripts')
<script>
            const handleChange = () => {
            const fileUploader = document.querySelector('#input-file');
                const getFile = fileUploader.files
                if (getFile.length !== 0) {
                    const uploadedFile = getFile[0];
                    readFile(uploadedFile);
                }
            }

            const readFile = (uploadedFile) => {
                if (uploadedFile) {
                    const reader = new FileReader();
                    reader.onload = () => {
                    const parent = document.querySelector('.preview-box');
                    parent.innerHTML = `<img class="preview-content" src=${reader.result} />`;
                    };
                    
                    reader.readAsDataURL(uploadedFile);
                }
            };
        </script>

@endsection