@extends('layouts.user.master')

@section('title') Dashboard @endsection

@section('content')

 <div class="lg:w-3/4 md:w-2/3 md:px-3 mt-[30px] md:mt-0">
    <div>
    @if (session('error'))
                        <div class="alert text-red-600">
                            {{ session('error') }}
                        </div>
                    @endif
                    @if (session('success'))
                        <div class="alert text-green-600">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if($errors)
                        @foreach ($errors->all() as $error)
                            <div class="alert text-red-600">{{ $error }}</div>
                        @endforeach
                    @endif
</div>
                        <div class="p-6 rounded-md shadow dark:shadow-gray-800 bg-white dark:bg-slate-900">
                            <!-- @if (Session::has('success'))
                                <div class="alert text-green-600">{{ Session::get('success') }}</div>
                            @endif -->
                            <h5 class="text-lg font-semibold mb-4">Personal Detail :</h5>
                            <form method="post" action="{{url('/update-info')}}" >
                                @csrf
                                <div class="grid lg:grid-cols-2 grid-cols-1 gap-5">
                                    <div>
                                        <label class="form-label font-medium">Name<span class="text-red-600">*</span></label>
                                        <div class="form-icon relative mt-2">
                                            <i data-feather="user" class="w-4 h-4 absolute top-3 left-4"></i>
                                            <input type="text" class="form-input pl-12" placeholder="Name:" id="name" name="name" required="" value="{{Auth()->user()->name}}">
                                        </div>
                                    </div>
                                    <div>
                                        <label class="form-label font-medium">Your Email : <span class="text-red-600">(not editable)</span> </label>
                                        <div class="form-icon relative mt-2">
                                            <i data-feather="mail" class="w-4 h-4 absolute top-3 left-4"></i>
                                            <input type="email" class="form-input pl-12" placeholder="Email" name="email" disabled value="{{Auth()->user()->email}}">
                                        </div>
                                    </div>
                                </div><!--end grid-->
                                <input type="submit" id="submit" name="send" class="btn bg-indigo-600 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white rounded-md mt-5" value="Save Changes">
                            </form><!--end form-->
                        </div>

                         <div class="p-6 rounded-md shadow dark:shadow-gray-800 bg-white dark:bg-slate-900 mt-[30px]">
                            <div class="grid lg:grid-cols-2 grid-cols-1 gap-5">
                                <div> 
                                    <h5 class="text-lg font-semibold mb-4">Change password :</h5>
                                    <form method="post" action="{{url('/update-password')}}">
                                        @csrf
                                        <div class="grid grid-cols-1 gap-5">
                                            <div>
                                                <label class="form-label font-medium">Old password :</label>
                                                <div class="form-icon relative mt-2">
                                                    <i data-feather="key" class="w-4 h-4 absolute top-3 left-4"></i>
                                                    <input class="form-input pl-12"  id="current-password" type="password" class="form-control" name="current-password" required >
                                                </div>

                                            </div>
    
                                            <div>
                                                <label class="form-label font-medium">New password :</label>
                                                <div class="form-icon relative mt-2">
                                                    <i data-feather="key" class="w-4 h-4 absolute top-3 left-4"></i>
                                                    <input class="form-input pl-12" id="new-password" type="password" class="form-control" name="new-password" required>
                                                </div>
                                            </div>
    
                                            <div>
                                                <label class="form-label font-medium">Re-type New password :</label>
                                                <div class="form-icon relative mt-2">
                                                    <i data-feather="key" class="w-4 h-4 absolute top-3 left-4"></i>
                                                    <input  class="form-input pl-12" id="new-password-confirm" type="password" class="form-control" name="new-password_confirmation" required>
                                                </div>
                                            </div>
                                        </div><!--end grid-->
    
                                        <button class="btn bg-indigo-600 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white rounded-md mt-5">Save password</button>

                                    </form>
                                    
                                </div><!--end col-->
                                
                                
                            </div><!--end row-->
                        </div>

                    </div>

@endsection