<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AppraisalController;
use App\Http\Controllers\CategoryController;

use App\Models\User;
use Illuminate\Auth\Events\Registered;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'HomeController@display')->name('home');
Route::get('/blog/{id}', 'HomeController@article');
Route::get('/blog', 'HomeController@articles')->name('blog');

Route::get('/appraisal', 'AppraisalController@evaluate');
Route::get('/appraisal/{hash}', 'AppraisalController@public_appraisal');

Route::get('/admin/categories', 'AdminController@Showcategories');
Route::post('categories/update/{id}', 'AdminController@Updatecategories');

//->middleware('verified');
Route::get('/pricing', 'HomeController@pricing')->name('pricing');
Route::get('/premium', 'HomeController@premium')->name('premium');
Route::get('/contact', 'HomeController@contact')->name('contact');

Route::get('purchase/{package_id}', 'HomeController@select_package')->middleware('verified');
Route::get('dashboard/billing/{package_name}', 'HomeController@selected_package')->middleware('verified');
Route::get('dashboard/billing', 'HomeController@billing')->middleware('verified');
Route::get('dashboard/billing-success', 'HomeController@billing_success')->middleware('verified');

Route::get('/bulk-appraisals', 'HomeController@bulk')->name('bulk')->middleware('verified');
Route::post('/bulk-appraisals-report', 'HomeController@bulk_report')->name('bulk-report')->middleware('verified');
Route::get('/domain-appraisal', 'HomeController@domain_appraisal')->name('domain-appraisal')->middleware('verified');
//Dashboard Routes
Route::get('/dashboard', 'HomeController@dashboard')->name('dashboard')->middleware('verified');
Route::get('/dashboard/profile', 'HomeController@dashboard')->name('profile')->middleware('verified');
Route::get('/dashboard/appraisal-history', 'HomeController@appraisal_history')->name('history')->middleware('verified');
Route::get('/dashboard/settings', 'HomeController@settings')->name('settings')->middleware('verified');

Route::post('/update-info', 'HomeController@settings_update_info');
Route::post('/update-password', 'HomeController@settings_update_password');



Route::get('/logout', function(){
    if (Auth::user()) {
    Auth::logout();

    return Redirect::home();
    }
})->name('logout');




Route::get('/mail', function(){

});

require __DIR__.'/auth.php';
