<?php $__env->startSection('title'); ?> Signup <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<section class="md:h-screen py-36 flex items-center bg-no-repeat bg-center" style="background: url('<?php echo e(asset("assets/user/images/bg/login.jpg")); ?>') no-repeat center center / cover">
            <div class="absolute inset-0 bg-gradient-to-b from-transparent to-black"></div>
            <div class="container">
                <div class="flex justify-center">
                    <div class="max-w-[400px] w-full m-auto p-6 bg-white dark:bg-slate-900 shadow-md dark:shadow-gray-800 rounded-md">
                        <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('assets/logo.png')); ?>" class="mx-auto" alt="" width="200"></a>
                        <h5 class="my-6 text-2xl font-bold text-indigo-600">Register</h5>
                        <form class="text-left" action="<?php echo e(route('register')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="grid grid-cols-1">
                                <div class="mb-4">
                                    <label class="font-semibold" for="LoginPassword">Name:</label>
                                    <input class="form-control form-input mt-3" value="<?php echo e(old('name')); ?>" type="text" id="name" class="form-control" name="name" placeholder="John Doe" required autofocus > 
                                    <?php if($errors->has('name')): ?>
                                          <span class="text-red-600 text-sm"><?php echo e($errors->first('name')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="mb-4">
                                    <label class="font-semibold" for="LoginEmail">Email Address:</label>
                                    <input class="form-control form-input mt-3" value="<?php echo e(old('email')); ?>" type="email" id="email_address" class="form-control" name="email" placeholder="name@example.com" required autofocus >
                                    <?php if($errors->has('email')): ?>
                                      <span class="text-red-600 text-sm"><?php echo e($errors->first('email')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="mb-4">
                                    <label class="font-semibold" for="LoginPassword">Password:</label>
                                    <input type="password" id="password" class="form-control form-input mt-3" name="password" placeholder="Password">
                                    <?php if($errors->has('password')): ?>
                                      <span class="text-red-600 text-sm"><?php echo e($errors->first('password')); ?></span>
                                    <?php endif; ?>
                                </div>

                                <div class="mb-4">
                                    <label class="font-semibold" for="LoginPassword">Confirm Password:</label>
                                    <input type="password" id="password_confirmation" class="form-control form-input mt-3" name="password_confirmation" placeholder="Repeat Password">
                                    <?php if($errors->has('password_confirmation')): ?>
                                      <span class="text-red-600 text-sm"><?php echo e($errors->first('password_confirmation')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="mb-4">
                                    <input type="submit" class="btn bg-indigo-600 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white rounded-md w-full" value="Sign up">
                                </div>
                                <div class="text-center">
                                    <span class="text-slate-400 me-2">Already have an account ?</span> <a href="<?php echo e(route('login')); ?>" class="text-black dark:text-white font-bold">Sign In</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section><!--end section -->


        <!-- Switcher -->
        <div class="fixed top-1/4 -right-1 z-3">
            <span class="relative inline-block rotate-90">
                <input type="checkbox" class="checkbox opacity-0 absolute" id="chk" />
                <label class="label bg-slate-900 dark:bg-white shadow dark:shadow-gray-800 cursor-pointer rounded-full flex justify-between items-center p-1 w-14 h-8" for="chk">
                    <i class="uil uil-moon text-[20px] text-yellow-500"></i>
                    <i class="uil uil-sun text-[20px] text-yellow-500"></i>
                    <span class="ball bg-white dark:bg-slate-900 rounded-full absolute top-[2px] left-[2px] w-7 h-7"></span>
                </label>
            </span>
        </div>
        <!-- Switcher -->

        <!-- JAVASCRIPTS -->
        <script src="<?php echo e(asset('assets/user/libs/feather-icons/feather.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/plugins.init.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/app.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user.master-auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/areteapps/public_html/meveu.com/dat2/resources/views/auth/register.blade.php ENDPATH**/ ?>