<?php $__env->startSection('title'); ?> Domain Appraisal <?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style type="text/css">
        .ajaxLoader
            {
                display: inline-block;
                width: 50px;
                vertical-align: middle;
                margin:10px auto;
                align-content: center;
                text-align: center;
                display:none;
            }
            .message-box{
/*              display: none;*/
                margin: 0 auto;
/*              width: 60%;*/
            }
            
/*
            .hide{
                display: none;
            }
*/

            @media (max-width: 640px) {
          .message-box{

                width: 100%;
            }
        }

        .domainAppraisalBasicInfoContainer.show, .domainAppraisalRegisterInfoContainer.show, .domainAppraisalActivityInfoContainer.show, message-box.show{
          display: block !important;
          opacity: 0;
          animation-name: bounceIn;
          animation-duration: 450ms;
          animation-timing-function: linear;
          animation-fill-mode: forwards;
        }

        .domainAppraisalBasicInfoContainer.hide, .domainAppraisalRegisterInfoContainer.hide, .domainAppraisalActivityInfoContainer.hide, message-box.hide{
          display: none;
          opacity: 0;
          animation-name: bounceOut;
          animation-duration: 300ms;
          animation-timing-function: linear;
          animation-fill-mode: forwards;
        }
        img.status{
          opacity: 0;
          animation-name: bounceIn;
          animation-duration: 200ms;
          animation-timing-function: linear;
          animation-fill-mode: forwards;
        }
        img.status{animation-delay: 0.2s;}





        @keyframes  bounceIn{
          0%{
            opacity: 0;
            transform: scale(0.3) translate3d(0,0,0);
          }
          50%{
            opacity: 0.9;
            transform: scale(1.1);
          }
          80%{
            opacity: 1;
            transform: scale(0.89);
          }
          100%{
            opacity: 1;
            transform: scale(1) translate3d(0,0,0);
          }
        }

        @keyframes  bounceOut{ 
          0%{
            opacity: 1;
            transform: scale(1);
            /*display: block;*/
          }
          10%{
            opacity: 1;
            transform: scale(1.1);
          }
          20%{
            opacity: 0.9;
            transform: scale(1) translate3d(0,0,0);
          }
          100%{
            opacity: 0;
            transform: scale(0) translate3d(0,0,0);
            /*display: none;*/
          }

        }

        .main-search-section {
            background: linear-gradient(-45deg,  #ECF8E9, #f7f7f7, #D3E8E8,  #cef2e5, #dcedc1,#E1FAEE, #ffffff);
            background-size: 500% 500%;
            animation: main-search-section-gradient 50s ease infinite;
        }

        @keyframes  main-search-section-gradient {
            0% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
            100% {
                background-position: 0% 50%;
            }
        }

        .half-div-left,  .half-div-right{
            width: 49%;
            padding: 15px;
            text-align: left;
            font-size: 14px;
        }

        .half-div-left{
            float: left;
        }
        .half-div-right{
            float:right;
        }
        #message{
            font-size: 16px;
            margin-top: 10px !important;
        }

        @media (max-width: 640px) {
          .half-div-left,  .half-div-right{
                width: 100%;
                padding: 0 15px;
                text-align: center;
            }
        }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Hero Start -->
        <section class="relative mt-20">
            <div class="container-fluid">
                <div class="relative pt-48 pb-60 table w-full shadow-md overflow-hidden">
                    <div class="absolute inset-0 overflow-hidden">
                        <div class="image-wrap absolute -top-[350px] -bottom-[350px] -left-[100px] -right-[100px] min-w-full w-auto min-h-full h-auto overflow-hidden m-auto" id="home"></div>
                    </div>
                    <div class="absolute inset-0 bg-black/80"></div>
                    <div class="container">
                        <div class="grid grid-cols-1">
                            <div class="md:text-left text-center">
                                <h1 class="font-bold text-white lg:leading-normal leading-normal text-4xl lg:text-5xl mb-6">Discover Your <br> .ETH Domain's Worth</h1>
                                <p class="text-white/70 text-xl max-w-xl">We provide consistent, unbiased and data driven ENS domain appraisal for domains that would normally have highly subjective values.</p>
                            </div>
                        </div><!--end grid-->
                    </div><!--end container-->
                </div>
            </div><!--end Container-->
        </section><!--end section-->
        <!-- Hero End -->

        <!-- Start -->
        <section class="relative md:pb-12 pb-8">
           
           
            
            
            <div class="container s130" id="s130Div">
                <div class="grid grid-cols-1 justify-center">
                    <div class="relative -mt-32">
                        <div class="grid grid-cols-1">
                            <div class="p-6 bg-white dark:bg-slate-900 rounded-md shadow-md dark:shadow-gray-800">
                                <form  id="QueryForm" method="GET" action="#" accept-charset="UTF-8" enctype="text/plain">
                                    <div class="registration-form text-dark text-start">
                                        <div class="grid lg:grid-cols-1 md:grid-cols- grid-cols-1 lg:gap-0 gap-6">
                                            <div class="filter-search-form relative filter-border">
                                                <i class="uil uil-search icons"></i>
                                                <input name="domain" id="domainName" type="text" id="job-keyword" class="form-input filter-input-box bg-gray-100 dark:bg-slate-800 border-0" placeholder="Search your .eth domain" onfocus-=" let value = this.value; this.value = null; this.value=value">
                                            </div>

                                            

                                            <div class="lg:mt-6">
                                                <input type="submit" id="search" name="submit" class="btn bg-indigo-600 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white searchbtn submit-btn w-full !h-12 rounded" value="Find Domain Worth">
                                            </div>
                                        </div><!--end grid-->
                                    </div><!--end container-->
                                </form>
                            </div>
                        </div><!--end grid-->
                    </div>
                </div><!--end grid-->
            </div><!--end container-->

           <div class="container text-center block" style="text-align: center !important">
				<img src="<?php echo e(asset('assets/user/images/loader.gif')); ?>" class="w-16 h-16 ajaxLoader"  alt="Processing..." title="Processing Your Request">
			   <div class="message-box mt-10"></div>
			</div>
           
           <div class="container domainAppraisalBasicInfoContainer hidden">
                <div class="grid md:grid-cols-12 pt-12 grid-cols-1 items-top gap-[30px]">
                    <div class="lg:col-span-4 md:col-span-6">
                        <div class="grid lg:grid-cols-1 md:grid-cols-1 grid-cols-1 mt-8 gap-[30px]">
							<div class="group rounded-md shadow bg-white dark:bg-slate-900">
								<div class="p-6 border-b border-gray-100 dark:border-gray-700">
									<h6 class="font-bold mb-3 text-lg uppercase">Domain Appraisal</h6>
									<p class="text-slate-400 mb-0">Estimated value of domain name based on system designed in collaboration with some of the most experienced collectors.</p>

									<h3 class="mt-5 md:text-2xl text-2xl md:leading-normal leading-normal font-bold text-indigo-600 domainNameHolder">domain.eth</h3>
									<div class="flex mb-0">

										<span class="text-xl font-semibold"><img src="<?php echo e(asset('assets/user/images/ether-black.svg')); ?>" class="w-4 h-4"></span>
										<span class="price text-4xl font-semibold mb-0 domainValueEHolder">0</span>
										<span class="text-xl font-semibold self-end mb-1"></span><span class="domainValueCHolder">00</span><span class="text-xl font-semibold self-end mb-1 text-slate-400">&nbsp; / $<span class="domainValueUsdHolder">000.00</span></span>
									</div>


								</div>

								<div class="p-6 border-b border-gray-100 dark:border-gray-700">
									<h6 class="mb-3 font-semibold">Domain Name Attributes:</h6>
									<ul class="list-none text-slate-400 domainAttributesHolder">
										
										
									</ul>
								</div>

								<div class="p-6 border-b border-gray-100 dark:border-gray-700">

									<a href="<?php echo e(route('premium')); ?>" class="btn bg-indigo-600 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white rounded-md w-full">Request Premium Appraisal</a>
								</div>
							</div>

                            
                            
                            
                            
                            
                            
                            
                            
                        </div>
					</div>
                    <div class="lg:col-span-8 md:col-span-6 mt-8 md:mt-0">
                        <div class="lg:ml-5">
                            <div class="flex mb-4">
								
								<span class="text-xl font-semibold"><img src="<?php echo e(asset('assets/user/images/ether-black.svg')); ?>" class="w-6; h-6"></span>
                                <span class="price text-2xl font-semibold mb-0 text-indigo-600"><span class="counter-value text-6xl font-bold domainValueEHolder" data-target="00">0</span></span>
								<span class="text-xl font-semibold self-end mb-1">.</span>
                                <span class="counter-value text-xl font-semibold self-end mb-1 text-slate-400 domainValueCHolder" data-target="00">00</span>
								
								
                            </div>

                            <h3 class="mb-6 md:text-4xl text-3xl md:leading-normal leading-normal font-bold domainNameHolder">domain.eth</h3>

                            <p class="text-slate-400 mb-10">This estimation is automatically calculated by the tool by collectors, for collectors and we believe that it can benefit the entire community, leading to a more stable and safe space for all of us. Our goal is to create a baseline valuation so that bidding can begin.<br>
							For an indepth and detailed report, please request <a href="#" class="text-indigo-600">Premium Domain Appraisal</a></p>
                        
                            <div class="domainCategoriesContainer"></div>
							
                        </div>
						
						
						
						<div class="lg:col-span-4 my-6 mt-12 domainLastSalePriceContainer">
							<!-- Content -->
							<div class="group relative p-6 shadow dark:shadow-gray-800 hover:shadow-md dark:hover:shadow-gray-700 hover:bg-indigo-600 dark:hover:bg-indigo-600 transition-all duration-500 bg-gray-100 ease-in-out rounded-xl bg-white dark:bg-slate-900 overflow-hidden text-center">
								<div class="relative overflow-hidden text-transparent -m-3">
									<i data-feather="hexagon" class="h-24 w-24 fill-indigo-600/5 group-hover:fill-white/10 mx-auto"></i>
									<div class="absolute top-2/4 -translate-y-2/4 left-0 right-0 mx-auto text-indigo-600 rounded-xl group-hover:text-white transition-all duration-500 ease-in-out text-3xl flex align-middle justify-center items-center">
										<i class="uil uil-chart-line"></i>
									</div>
								</div>

								<div class="mt-6">
									<a href="" class="text-lg font-medium group-hover:text-white text-indigo-600 transition-all duration-500 ease-in-out">Last Sale Price</a>
									<p class="text-slate-400 text-xl font-bold group-hover:text-white/50 transition-all duration-500 ease-in-out mt-3 domainLastSalePriceHolder"></p>
								</div>
							</div>
							<!-- Content -->
						</div>
						
						
                    </div>
                </div><!--end grid-->
            </div><!--end container-->
            
            <div class="container  domainAppraisalRegisterInfoContainer hidden">
                <div class="md:flex justify-center">
                    <div class="py-12">
                        <div class="grid md:grid-cols-3 grid-cols-1 gap-[24px]">
							
                            <div class="group flex p-6 md:px-4 rounded-lg shadow dark:shadow-gray-800 hover:shadow-md dark:hover:shadow-gray-700 bg-gray-50 dark:bg-slate-900 hover:-translate-y-2 transition-all duration-500 ease-in-out">
								
                                <div class="min-w-[64px] h-16 bg-indigo-600/5 text-indigo-600 rounded-lg text-2xl flex align-middle justify-center items-center shadow-sm dark:shadow-gray-800 mx-auto">
                                    <i class="uil uil-calender  text-green-600"></i>
                                </div>

                                <div class="content ml-4 flex-1">
                                    <a class="title h5 text-lg font-medium hover:text-indigo-600 domainCreationDateHolder"></a>
                                    <p class="text-slate-400 mt-2">Creation Date</p>
                                </div>
								
								
                            </div>
                            <!--end feature content-->

                            <div class="group flex p-6 md:px-4 rounded-lg shadow dark:shadow-gray-800 hover:shadow-md dark:hover:shadow-gray-700 bg-gray-50 dark:bg-slate-900 hover:-translate-y-2 transition-all duration-500 ease-in-out">
                                <div
                                    class="min-w-[64px] h-16 bg-indigo-600/5 text-indigo-600 rounded-lg text-2xl flex align-middle justify-center items-center shadow-sm dark:shadow-gray-800 mx-auto">
                                    <i class="uil uil-calendar-alt"></i>
                                </div>

                                <div class="content ml-4 flex-1">
                                    <a class="title h5 text-lg font-medium hover:text-indigo-600 domainRegistrationDateHolder"></a>
                                    <p class="text-slate-400 mt-2">Registration Date</p>
                                </div>
                            </div>
                            <!--end feature content-->

                            <div class="group flex p-6 md:px-4 rounded-lg shadow dark:shadow-gray-800 hover:shadow-md dark:hover:shadow-gray-700 bg-gray-50 dark:bg-slate-900 hover:-translate-y-2 transition-all duration-500 ease-in-out">
                                <div
                                    class="min-w-[64px] h-16 bg-indigo-600/5 text-indigo-600 rounded-lg text-2xl flex align-middle justify-center items-center shadow-sm dark:shadow-gray-800 mx-auto">
                                    <i class="uil uil-calendar-slash text-red-600"></i>
                                </div>

                                <div class="content ml-4 flex-1">
                                    <a href="page-services.html" class="title h5 text-lg font-medium hover:text-indigo-600 domainExpiryDateHolder"></a>
                                    <p class="text-slate-400 mt-2">Expiry Date</p>
                                </div>
                            </div>
                            <!--end feature content-->

                        </div>
                    </div>
                </div><!--end grid-->
            </div><!--end container-->
		</section>
		
		
     <!-- Start -->
        <section class="relative md:py-24 py-16 bg-gray-50 dark:bg-slate-800  domainAppraisalActivityInfoContainer hidden">
            <div class="container">
                <div class="grid grid-cols-1 pb-8 text-center">
                    <h6 class="text-indigo-600 text-md font-bold mb-2 domainNameHolder">domain.eth</h6>
                    <h3 class="mb-4 md:text-3xl md:leading-normal text-2xl leading-normal font-semibold">Recent Domain Activity</h3>

                    
                </div><!--end grid-->

                <div class="grid grid-cols-1 mt-2">
                    <div class="timeline relative domainActivityContainer">
                                             
                        
                    </div>
                </div><!--end grid-->
            </div><!--end container-->
        </section><!--end section-->
        <!-- End -->
       
   		<!-- Start -->
        <section class="relative md:pb-24 pb-16">

            <div class="container lg:mt-12 mt-8 lg:pt-12 pt-16">
                <div class="absolute inset-0 opacity-25 dark:opacity-50 bg-[url('../../assets/images/map.html')] bg-no-repeat bg-center"></div>
                <div class="relative grid grid-cols-1 pb-8 text-center z-1">
                    <h3 class="mb-6 md:text-3xl text-2xl md:leading-normal leading-normal font-semibold text-black dark:text-white">Trusted by more than 10K users</h3>

                    <p class="text-slate-400 max-w-xl mx-auto">Start working with our Domain Appraisal Tool that can provide everything you need to evaluate your .ETH domain names.</p>
                </div><!--end grid-->

                <div class="relative grid md:grid-cols-3 grid-cols-1 items-center mt-8 gap-[30px] z-1">
                    <div class="counter-box text-center">
                        <h1 class="lg:text-5xl text-4xl font-semibold mb-2 text-slate-400 dark:text-white"><span class="counter-value" data-target="1548">1010</span>+</h1>
                        <h5 class="counter-head text-lg font-medium">Assisted Names Sell</h5>
                    </div><!--end counter box-->
                    
                    <div class="counter-box text-center">
                        <h1 class="lg:text-5xl text-4xl font-semibold mb-2 text-slate-400 dark:text-white"><span class="counter-value" data-target="25">2</span>+</h1>
                        <h5 class="counter-head text-lg font-medium">Award Gained</h5>
                    </div><!--end counter box-->
                    
                    <div class="counter-box text-center">
                        <h1 class="lg:text-5xl text-4xl font-semibold mb-2 text-slate-400 dark:text-white"><span class="counter-value" data-target="9">0</span>+</h1>
                        <h5 class="counter-head text-lg font-medium">Years Experience</h5>
                    </div><!--end counter box-->
                </div>
            </div><!--end container-->

            
            <div class="container lg:mt-24 mt-16">
                <div class="grid grid-cols-1 text-center">
                    <h3 class="mb-6 md:text-3xl text-2xl md:leading-normal leading-normal font-semibold">Have Question ? Get in touch!</h3>

                    <p class="text-slate-400 max-w-xl mx-auto">Start working with DOMAIN APPRAISAL TOOL that can provide everything you need to generate awareness, drive traffic, connect.</p>
                
                    <div class="mt-6">
                        <a href="<?php echo e(route('contact')); ?>" class="btn bg-indigo-600 hover:bg-indigo-700 border-indigo-600 hover:border-indigo-700 text-white rounded-md"><i class="uil uil-phone align-middle mr-2"></i> Contact us</a>
                    </div>
                </div><!--end grid-->
            </div><!--end container-->
        </section><!--end section-->
        <!-- End -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
            easy_background("#home",
                {
                    slide: ["<?php echo e(asset('assets/user/images/bg/domain-appraisal-1.jpg')); ?>", "<?php echo e(asset('assets/user/images/bg/domain-appraisal-2.jpg')); ?>", "<?php echo e(asset('assets/user/images/bg/domain-appraisal-3.jpg')); ?>"],
                    delay: [15000, 15000, 15000]
                }
            );
        </script>
		
		<script src="<?php echo e(asset('assets/user/js/uikit.js')); ?>"></script>
		<script src="https://code.jquery.com/jquery-1.9.1.js"></script>



<script>
$(document).ready(function() {

	var i=1;
    $('#QueryForm').submit(function(e) {
		i++;
        
        $('.message-box').addClass("hide");
		$('.message-box').html("");
		$(".domainAppraisalBasicInfoContainer").addClass("hide");
		
		$(".domainAppraisalRegisterInfoContainer").addClass("hide");
		$(".domainAppraisalRegisterInfoContainer").removeClass("visible").removeClass("show");
		$(".domainAppraisalActivityInfoContainer").addClass("hide");
		$(".domainAppraisalActivityInfoContainer").removeClass("visible").removeClass("show");
		
		$(".domainLastSalePriceContainer").addClass("hidden").removeClass("visible");
		$('.domainNameHolder').html("");
       	$(".domainAttributesHolder").html("");
		$(".domainValueEHolder").html("00");
		$(".domainValueCHolder").html("00");
		$(".domainValueUsdHolder").html("");
		$(".domainLastSalePriceHolder").html("");
		$(".domainCategoriesContainer").html("");
		$(".domainActivityContainer").html("");
		//$(".domainAppraisalBasicInfoContainer").removeClass("visible").removeClass("show");
		
		
        e.preventDefault();
        if(i==3){
        	
        	// exit;
        }

       $('.ajaxLoader').show();
		
		//var domainField = $("input[name='domain']");
        var domain = $("input[name='domain']").val();

        $.ajax({
        	// headers: { "Accept": "application/json"},
            type: "GET",
            dataType: 'json',
            crossDomain: true,
            url: 'https://dat.meveu.com/domain-appraisal.php?domain='+domain,
            success: function(data)
            {
				
                if (!data.value) 
                { //If fails

                    { //Returned if any error from search.php
                    	$('.ajaxLoader').hide();
                        $('.message-box').fadeIn(1000).html('<div style="padding: 8px; color: #dc2626; background-color: rgba(219, 38, 38, 0.05); border: 1px solid rgba(219, 38, 38, 0.05); border-radius: 6px; text-align: left; font-size: 16px; font-weight: 600;"> <strong>Warning:</strong> '+ data.error+'</div>');
                    }
                }
                else 
                {
//                	$('#message-box').removeClass('hidden');
//                	$('#message-box').addClass('visible');
//					
					//inp.focus();
//					inp.focus();
//					domainField.focus();
					var array = $.map(data, function(value, index){
						return [value];
					});

					//console.log(array);
					//console.log(data);
					// $('.message-box').show();
                	
                	$('.ajaxLoader').hide();
                	// $("#statusImg").hide();
                	$('.domainNameHolder').html(data.name);
                	
					//$('.domainNameLengthHolder').html(data.length);
					
					if(data.length)
						$(".domainAttributesHolder").append('<li class="mb-1 flex"><span class="text-emerald-600 h5 me-1"><i class="uil uil-check-circle text-xl mr-2"></i></span> <b class="text-black dark:text-white">Name Length</b>: &nbsp; '+ data.length +'</li>');
                	
					
					if(data.unicode == 0)
					{
						$(".domainAttributesHolder").append('<li class="mb-1 flex"><span class="text-emeral-600 h5 me-1"><i class="uil uil-check-circle text-xl mr-2"></i></span> No Unicode Characters</li>');	
					}
                	else
					{
						$(".domainAttributesHolder").append('<li class="mb-1 flex"><span class="text-red-600 h5 me-1"><i class="uil uil-times-circle text-xl mr-2"></i></span> Contains Unicode Characters</li>');
					}
						
                     
					
					
                    if(data.value_usd){
                		$(".domainValueUsdHolder").html(data.value_usd);	
                    }
					
					const domainValueArr = (data.value).split('.');
					console.log(domainValueArr);
					if(domainValueArr.length==1)
					{
						$(".domainValueCHolder").html("00");
						$(".domainValueCHolder").data("target",00);
					}
					else
					{
						$(".domainValueCHolder").html(domainValueArr[1]);
						$(".domainValueCHolder").data("target",domainValueArr[1]);
					}
						
					
					$(".domainValueEHolder").html(domainValueArr[0]);
					$(".domainValueEHolder").data("target",domainValueArr[0]);
					
					
					 $(".domainAppraisalBasicInfoContainer").addClass("show").removeClass("hidden").removeClass("hide");
                    
					if(data.creation_date)
                		$(".domainCreationDateHolder").html(data.creation_date);
						
					if(data.registration_date)
                		$(".domainRegistrationDateHolder").html(data.registration_date);
						
					if(data.expiration_date)
                		$(".domainExpiryDateHolder").html(data.expiration_date);
					
					if(data.creation_date || data.registration_date || data.expiration_date)
					{
						$(".domainAppraisalRegisterInfoContainer").addClass("show").removeClass("hidden").removeClass("hide");	
					}
                		 
					
					if(data.last_sale_price)
					{
						$(".domainLastSalePriceHolder").html("<b class='text-indigo-600 group-hover:text-white'><img src='<?php echo e(asset("assets/user/images/ether.svg")); ?>' class='w-4 h-4 inline-block'>" + data.last_sale_price + "</b> on <b>" + data.last_sale_time + "</b>");
						$(".domainLastSalePriceContainer").removeClass("hidden").removeClass("hide");
						$(".domainLastSalePriceContainer").addClass("visible");
					}
					else
						$(".domainLastSalePriceContainer").addClass("hidden");
                    
                    
					if(data.categories && data.categories.length)
					{
						jQuery.each( data.categories, function( i, category )
						{
							$(".domainCategoriesContainer").append('<div class="mt-4"><div class="flex justify-between mb-2"><span class="text-slate-400">'+ category.category_name +'</span><span class="text-slate-400">'+ category.category_score +'</span></div><div class="w-full bg-gray-100 dark:bg-gray-800 rounded-full h-[6px]"><div class="bg-indigo-600 h-[6px] rounded-full" style="width: ' + category.category_score +'%"></div></div></div>');
						});
					}
					
					if(data.activity && data.activity.length)
					{
						jQuery.each( data.activity, function( i, activity )
						{
							$(".domainActivityContainer").append('<div class="timeline-item mt-8"><div class="grid sm:grid-cols-2"><div class="mt-4 mt-sm-0"><div class="duration date-label-left md:text-right md:mr-8 relative"><h5 class="my-2  text-indigo-600 font-bold">'+activity.type+'</h5><h6 class="text-slate text-sm mb-0"><img src="<?php echo e(asset('assets/user/images/ether-black.svg')); ?>" class="w-3 h-3 inline-block"> &nbsp; '+activity.price+'</h6></div></div><div class="mt-4 mt-sm-0"><div class="event event-description-right float-left text-left md:ml-8"><h5 class="title mb-1 font-semibold">'+ activity.time +'</h5></div></div></div> </div>');
						});
						
						$(".domainAppraisalActivityInfoContainer").addClass("show").removeClass("hidden").removeClass("hide");
					}
					
					
					
					
					
                        
					
					
                    
//                    if(typeof data.release_date !== 'undefined')
//                    {
//                    	$('#release_date').html('<strong> Release Date:</strong><br> ' + data.release_date); 
//                    }
					
					
					//domainField.val(".pk");
					document.getElementById('s130Div').scrollIntoView(true); // Top
					//var element = document.querySelector("#s130Div");

					// smooth scroll to element and align it at the bottom
					//element.scrollIntoView({ behavior: 'smooth', block: 'end'});
					//var elmnt = document.getElementById("content");
					//elmnt.scrollIntoView();
					var inp = document.getElementById('domainName');
					inp.value=".eth";
					//inp.value=domain;
					if (inp.createTextRange) {
						var part = inp.createTextRange();
						part.move("character", 0);
						part.select();
					} else if (inp.setSelectionRange) {
						inp.setSelectionRange(0, 0);
					}
					
					inp.focus();
					
					
                }
            },
            error: function(jqXHR, textStatus, errorThrown)
            {
            	
            	$('.message-box').removeClass('hide');
                $('.message-box').addClass('show');
				// $('.message-box').show();
            	
            	$('.ajaxLoader').hide();
            	// $("#statusImg").hide();
				$('.message-box').html('<p>The request has resulted in ' + textStatus + '</p>');
            	
            		
                
                
            }
       });
        
     });
});

	
	
	
	

</script>

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user.master-no-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/areteapps/public_html/meveu.com/dat2/resources/views/user/domain_appraisal.blade.php ENDPATH**/ ?>